/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.bean.AppConfigPropBean;
import kd.epm.epbs.common.cache.helper.GlobalCacheServiceHelper;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.TXUtils;

public class AppVersionUtils {
    public static final String AppVersionCache = "epbs_version_cache_";

    public static String getInitVersion(String appnum) {
        return GlobalCacheServiceHelper.getCommonCache().getOrLoad(AppVersionCache + appnum, () -> {
            QFilter qFilter = new QFilter("appnum", "=", (Object)appnum);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_customversion", (String)"version", (QFilter[])qFilter.toArray(), (String)"version");
            String version = "0";
            if (dys.isEmpty()) {
                AppTypeEnum app = AppTypeEnum.getEnumByAppnum(appnum);
                if (!QueryServiceHelper.exists((String)"epbs_model", null)) {
                    version = AppVersionUtils.getCurVersion(appnum);
                }
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_customversion");
                dy.set("appnum", (Object)app.getAppNum());
                dy.set("version", (Object)version);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            } else {
                version = ((DynamicObject)dys.get(0)).getString("version");
            }
            return version;
        });
    }

    public static String getCurVersion(String appnum) {
        return ConfigurationContext.INSTANCE.loadProp(appnum, new AppConfigPropBean("version", "0"));
    }

    public static void createVersion(AppTypeEnum appType, String version) {
        TXUtils.requiresNew(appType.getAppNum() + ".verson.create", tx -> {
            QFilter qf = new QFilter("appnum", "=", (Object)appType.getAppNum()).and("version", "=", (Object)version);
            if (!QueryServiceHelper.exists((String)"epbs_customversion", (QFilter[])qf.toArray())) {
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_customversion");
                dy.set("appnum", (Object)appType.getAppNum());
                dy.set("version", (Object)version);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            }
        });
    }
}

