/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.impl.ThreadPoolImpl;

public class BatchProcessHelper {
    private static final Log LOG = LogFactory.getLog(BatchProcessHelper.class);
    private static final int TOTAL_THREAD_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    public static final int COMMON_THREAD_TIMEOUT_SEC = 1000;
    public static final int CPU_SCENE_RECOMMEND_THREAD = Math.min(Runtime.getRuntime().availableProcessors(), 8);
    private static ThreadPool SYNC_THREAD_POOL = null;
    private static ThreadPool ASYNC_THREAD_POOL;

    private BatchProcessHelper() {
    }

    public static <R, T> List<R> batchHandle(List<T> data, int batchThreshold, int minBatchSize, Function<List<T>, List<R>> processFunction, Integer timeoutSeconds, Scene applyScene) {
        if (Objects.isNull((Object)applyScene)) {
            throw new IllegalArgumentException("param applyScene must be specific.");
        }
        int specificThreadCnt = Runtime.getRuntime().availableProcessors();
        switch (applyScene) {
            case IO: {
                specificThreadCnt = TOTAL_THREAD_SIZE - 2;
                break;
            }
            case CPU: {
                specificThreadCnt = Math.min(data.size() / minBatchSize + 1, CPU_SCENE_RECOMMEND_THREAD);
                break;
            }
        }
        return BatchProcessHelper.batchHandle(data, batchThreshold, processFunction, timeoutSeconds, specificThreadCnt);
    }

    public static <R, T> List<R> batchHandle(List<T> data, int batchThreshold, Function<List<T>, List<R>> processFunction, Integer timeoutSeconds, int specificThreadCnt) {
        Preconditions.checkState((batchThreshold > 0 ? 1 : 0) != 0, (Object)"param batchThreshold must exceed 0");
        if (Objects.isNull(timeoutSeconds) || timeoutSeconds <= 0) {
            timeoutSeconds = 1000;
        }
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        List<Object> itemResults = new ArrayList(data.size());
        if (data.size() > batchThreshold) {
            int threadSize = Math.min(specificThreadCnt, TOTAL_THREAD_SIZE);
            int batchSize = Math.max(1, data.size() / threadSize);
            ArrayList<Future> futures = new ArrayList<Future>(threadSize);
            int consumListIndex = 0;
            for (int k = 0; k < threadSize; ++k) {
                consumListIndex = k < threadSize - 1 && (k + 1) * batchSize < data.size() ? (k + 1) * batchSize : data.size();
                List batchData = data.subList(k * batchSize, consumListIndex);
                OperationContext oc = OperationContext.get();
                futures.add(SYNC_THREAD_POOL.submit(() -> {
                    try {
                        OperationContext.set((OperationContext)oc);
                        return (List)processFunction.apply(batchData);
                    }
                    catch (Exception e) {
                        LOG.error("batch_process_fail on: " + e.getMessage(), (Throwable)e);
                        throw new KDBizException(e.getMessage());
                    }
                }, RequestContext.get()));
                if (consumListIndex >= data.size()) break;
            }
            for (Future future : futures) {
                try {
                    List batchItemResults = (List)future.get(timeoutSeconds.intValue(), TimeUnit.SECONDS);
                    itemResults.addAll(batchItemResults);
                }
                catch (ExecutionException | TimeoutException e) {
                    LOG.error("failed_to_process_dimension_import on: " + e.getMessage(), (Throwable)e);
                    throw new KDBizException(BatchProcessHelper.threadExecutionErr(e.getMessage()));
                }
                catch (InterruptedException e) {
                    LOG.error("interrupted_to_process_dimension_import on: " + e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                    throw new KDBizException(BatchProcessHelper.threadExecutionErr(e.getMessage()));
                }
            }
        } else {
            itemResults = processFunction.apply(data);
        }
        return itemResults;
    }

    public static <R, T> List<R> handle(List<T> data, Function<T, R> processFunction, Integer timeoutSeconds) {
        if (Objects.isNull(timeoutSeconds) || timeoutSeconds <= 0) {
            timeoutSeconds = 1000;
        }
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        ArrayList<Future> futures = new ArrayList<Future>(data.size());
        ArrayList itemResults = new ArrayList(data.size());
        for (Object task : data) {
            OperationContext oc = OperationContext.get();
            futures.add(SYNC_THREAD_POOL.submit(() -> {
                try {
                    OperationContext.set((OperationContext)oc);
                    return processFunction.apply(task);
                }
                catch (Exception e) {
                    LOG.error("batch_process_fail on: " + e.getMessage(), (Throwable)e);
                    throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)BatchProcessHelper.threadExecutionErr(e.getMessage())), new Object[0]);
                }
            }, RequestContext.get()));
        }
        for (Future future : futures) {
            try {
                Object taskResult = future.get(timeoutSeconds.intValue(), TimeUnit.SECONDS);
                itemResults.add(taskResult);
            }
            catch (ExecutionException | TimeoutException e) {
                LOG.error("batchprocess_error on: " + e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)BatchProcessHelper.threadExecutionErr(e.getMessage())), new Object[0]);
            }
            catch (InterruptedException e) {
                LOG.error("interrupted_batchprocess on: " + e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)BatchProcessHelper.threadExecutionErr(e.getMessage())), new Object[0]);
            }
        }
        return itemResults;
    }

    public static void submit(List<Callable> processFunctions) {
        if (!CollectionUtils.isEmpty(processFunctions)) {
            OperationContext oc = OperationContext.get();
            processFunctions.forEach(x -> SYNC_THREAD_POOL.submit(() -> {
                OperationContext.set((OperationContext)oc);
                return x.call();
            }, RequestContext.get()));
        }
    }

    public static <T> void batchConsume(List<T> dataList, int batchSize, Consumer<List<T>> consumer) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        if (dataList.size() < batchSize) {
            consumer.accept(dataList);
        } else {
            List<T> batch = null;
            int startIndex = 0;
            while (startIndex < dataList.size()) {
                int endIndex = startIndex + batchSize;
                if (endIndex > dataList.size()) {
                    endIndex = dataList.size();
                }
                batch = dataList.subList(startIndex, endIndex);
                consumer.accept(batch);
                startIndex = endIndex;
            }
        }
    }

    public static void pageConsume(int totalSize, int pageSize, Consumer<Integer> consumer) {
        if (totalSize < 1) {
            return;
        }
        if (totalSize < pageSize) {
            consumer.accept(0);
        } else {
            boolean pageIndex = false;
            int all = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
            for (int start = 0; start < all; ++start) {
                consumer.accept(start);
            }
        }
    }

    public static void handleAsync(Runnable runnable) {
        OperationContext oc = OperationContext.get();
        ASYNC_THREAD_POOL.execute(() -> {
            OperationContext.set((OperationContext)oc);
            runnable.run();
        }, RequestContext.get());
    }

    public static void handleSync(Runnable runnable) {
        OperationContext oc = OperationContext.get();
        CountDownLatch latch = new CountDownLatch(1);
        SYNC_THREAD_POOL.execute(() -> {
            OperationContext.set((OperationContext)oc);
            try {
                runnable.run();
            }
            finally {
                latch.countDown();
            }
        }, RequestContext.get());
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String threadExecutionErr(String errMsg) {
        return String.format(ResManager.loadKDString((String)"\u6279\u5904\u7406\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38\uff1a%s", (String)"BatchProcessHelper_1", (String)"epm-epbs-common", (Object[])new Object[0]), errMsg);
    }

    static {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(TOTAL_THREAD_SIZE, TOTAL_THREAD_SIZE, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "/fi/bcm/batchprocesshelper/sync-" + this.atomicInteger.incrementAndGet());
            }
        });
        executor.allowCoreThreadTimeOut(true);
        SYNC_THREAD_POOL = new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)executor), OperationContext.get(), x -> {});
        ASYNC_THREAD_POOL = null;
        int asyncThreadSize = 2;
        ThreadPoolExecutor executor2 = new ThreadPoolExecutor(asyncThreadSize, asyncThreadSize, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread newt = new Thread(r, "/fi/bcm/batchprocesshelper/async-" + this.atomicInteger.incrementAndGet());
                newt.setPriority(Math.min(newt.getPriority(), 2));
                return newt;
            }
        });
        executor2.allowCoreThreadTimeOut(true);
        ASYNC_THREAD_POOL = new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)executor2), OperationContext.get(), x -> {});
    }

    public static enum Scene {
        IO,
        CPU;

    }
}

