/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.servicehelper.MetadataServiceHelper;

public class CommonServiceHelper {
    public static List<Map<String, Object>> transDataSet(DataSet ds) {
        LinkedList<Map<String, Object>> rst = new LinkedList<Map<String, Object>>();
        if (ds == null || ds.isEmpty()) {
            return rst;
        }
        int count = ds.getRowMeta().getFieldCount();
        while (ds.hasNext()) {
            Row row = ds.next();
            LinkedHashMap<String, Object> rowObjs = new LinkedHashMap<String, Object>(count);
            for (int index = 0; index < count; ++index) {
                rowObjs.put(ds.getRowMeta().getFieldName(index).toLowerCase(), row.get(index));
            }
            rst.add(rowObjs);
        }
        return rst;
    }

    public static String getSelectFields(String formId) {
        return (String)CommonServiceHelper.getSelectFields(formId, Collectors.joining(","));
    }

    public static <T> T getSelectFields(String formId, Collector collector) {
        return (T)MetadataServiceHelper.getDataEntityType((String)formId).getProperties().stream().map(e -> e.getName()).collect(collector);
    }

    public static String getStackTraceStr(Throwable e) {
        StackTraceElement[] arr = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage()).append("\r\n");
        for (StackTraceElement ele : arr) {
            sb.append(ele.toString()).append("\r\n");
        }
        return sb.toString();
    }
}

