/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.orm.util.StringUtils;

public class ControlValIfNullUtil {
    public static Optional<String> validate(IFormView view) {
        return ControlValIfNullUtil.validate(view.getModel());
    }

    public static boolean validateFail2ShowTips(IFormView view) {
        Optional<String> s = ControlValIfNullUtil.validate(view.getModel());
        if (s.isPresent()) {
            view.showTipNotification(s.get());
            return true;
        }
        return false;
    }

    public static Optional<String> validate(IDataModel dataModel) {
        List list = dataModel.getDataEntityType().getAllFields().values().stream().filter(e -> {
            boolean isMustInput = false;
            if (e instanceof FieldProp) {
                isMustInput = ((FieldProp)e).isMustInput();
            } else if (e instanceof BasedataProp) {
                isMustInput = ((BasedataProp)e).isMustInput();
            } else if (e instanceof MulBasedataProp) {
                isMustInput = ((BasedataProp)e).isMustInput();
            }
            if (isMustInput) {
                return ControlValIfNullUtil.isNull(dataModel, e.getName());
            }
            return false;
        }).map(e -> "\"" + e.getDisplayName().getLocaleValue() + "\"").collect(Collectors.toList());
        return list.isEmpty() ? Optional.empty() : Optional.of(ControlValIfNullUtil.getMessage(String.join((CharSequence)",", list)));
    }

    public static Optional<String> validate(IFormView view, String ... controlKeys) {
        Map fields = view.getModel().getDataEntityType().getFields();
        ArrayList<String> list = new ArrayList<String>(controlKeys.length);
        for (String controlKey : controlKeys) {
            if (!ControlValIfNullUtil.isNull(view.getModel(), controlKey)) continue;
            list.add(((IDataEntityProperty)fields.get(controlKey)).getDisplayName().getLocaleValue());
        }
        return list.isEmpty() ? Optional.empty() : Optional.of(ControlValIfNullUtil.getMessage(String.join((CharSequence)",", list)));
    }

    public static boolean validateFail2ShowTips(IFormView view, String ... controlKeys) {
        Optional<String> s = ControlValIfNullUtil.validate(view, controlKeys);
        if (s.isPresent()) {
            view.showTipNotification(s.get());
            return true;
        }
        return false;
    }

    private static boolean isNull(IDataModel model, String controlKey) {
        Object value = model.getValue(controlKey);
        if (value == null || StringUtils.isEmpty((Object)value)) {
            return true;
        }
        return value instanceof OrmLocaleValue && StringUtils.isEmpty((Object)((OrmLocaleValue)value).getLocaleValue());
    }

    private static String getMessage(String e) {
        return ResManager.loadKDString((String)"%s\u7b49\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ControlValIfNullUtil_1", (String)"epm-epbs-common", (Object[])new Object[]{e});
    }
}

