/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.business.datamodel.DynamicFormModelProxy;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.util.GlobalIdUtil;

public class DynamicObjectUtils {
    public static final Log log = LogFactory.getLog(DynamicObjectUtils.class);
    private static final int DEFAULT_DYNAMIC_OBJECT_SIZE = 5000;
    private static final int MAX_BATCH_SIZE = 100000;

    public static DynamicObject newDynamicObject(String entityName) {
        DynamicFormModelProxy dynamicFormModelProxy = new DynamicFormModelProxy(entityName, GlobalIdUtil.genStringId(), new LinkedHashMap(16));
        return (DynamicObject)dynamicFormModelProxy.createNewData();
    }

    public static void save(List<DynamicObject> objects) {
        List<DynamicObject>[] batchObjects;
        if (objects == null || objects.isEmpty()) {
            return;
        }
        for (List<DynamicObject> batchObject : batchObjects = DynamicObjectUtils.getBatchObjects(objects, 5000)) {
            if (batchObject == null || batchObject.isEmpty()) continue;
            SaveServiceHelper.save((DynamicObject[])batchObject.toArray(new DynamicObject[0]));
        }
    }

    public static void update(List<DynamicObject> objects) {
        List<DynamicObject>[] batchObjects;
        if (objects == null || objects.isEmpty()) {
            return;
        }
        for (List<DynamicObject> batchObject : batchObjects = DynamicObjectUtils.getBatchObjects(objects, 5000)) {
            if (batchObject == null || batchObject.isEmpty()) continue;
            SaveServiceHelper.update((DynamicObject[])batchObject.toArray(new DynamicObject[0]));
        }
    }

    public static void save(DynamicObject[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        DynamicObject[][] batchObjects = DynamicObjectUtils.getBatchObjects(objects, 5000);
        if (batchObjects != null) {
            for (DynamicObject[] batchObject : batchObjects) {
                DynamicObject[] _tmpSave = batchObject;
                if (_tmpSave == null || _tmpSave.length <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])_tmpSave);
            }
        }
    }

    public static <T> List<T>[] getBatchObjects(List<T> objects, int batchSize) {
        if (objects == null || objects.isEmpty()) {
            return new List[0];
        }
        int count = (objects.size() - 1) / batchSize + 1;
        int fromIndex = 0;
        int toIndex = Math.min(batchSize, objects.size());
        List[] batchObjects = new List[count];
        for (int index = 0; index < count; ++index) {
            batchObjects[index] = objects.subList(fromIndex, toIndex);
            fromIndex += batchSize;
            if ((toIndex += batchSize) <= objects.size()) continue;
            toIndex = objects.size();
        }
        return batchObjects;
    }

    public static DynamicObject[][] getBatchObjects(DynamicObject[] objects, int batchSize) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        int count = (objects.length - 1) / batchSize + 1;
        int fromIndex = 0;
        int toIndex = Math.min(batchSize, objects.length);
        DynamicObject[][] batchObjects = new DynamicObject[count][0];
        for (int index = 0; index < count; ++index) {
            DynamicObject[] _objects = new DynamicObject[toIndex];
            System.arraycopy(objects, fromIndex, _objects, 0, toIndex);
            batchObjects[index] = _objects;
            toIndex = (fromIndex += batchSize) + batchSize <= objects.length ? batchSize : objects.length - fromIndex;
        }
        return batchObjects;
    }

    public static String getDisplayName(IDataEntityProperty property) {
        StringBuilder sb = new StringBuilder(property.getDisplayName().toString());
        IDataEntityType parent = property.getParent();
        while (parent instanceof EntryType) {
            sb.insert(0, parent.getDisplayName() + ".");
            parent = parent.getParent();
        }
        return sb.toString();
    }
}

