/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.common.util.Point;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExcelUtils {
    private static final int ZeroCharValue = 48;

    public static int pos2X(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2X(pos, colAxisIndex);
    }

    private static int pos2X(String pos, int colAxisIndex) {
        int count = -1;
        for (int i = 0; i < colAxisIndex; ++i) {
            char c = pos.charAt(i);
            count = c >= 'a' && c <= 'z' ? (int)((double)count + (double)(c - 96) * Math.pow(26.0, colAxisIndex - 1 - i)) : (int)((double)count + (double)(c - 64) * Math.pow(26.0, colAxisIndex - 1 - i));
        }
        return count;
    }

    public static int pos2Y(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2Y(pos, colAxisIndex);
    }

    private static int pos2Y(String pos, int colAxisIndex) {
        int result = 0;
        int j = 1;
        for (int i = pos.length() - 1; i >= colAxisIndex; --i) {
            char c = pos.charAt(i);
            if (c >= '0' && c <= '9') {
                result += (c - 48) * j;
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
            }
            j *= 10;
        }
        return result - 1;
    }

    private static int getColAxisIndex(String pos) {
        if (pos.length() <= 1) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
        }
        if (!Character.isLetter(pos.charAt(0))) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
        }
        if (!Character.isLetter(pos.charAt(1))) {
            return 1;
        }
        for (int index = 2; index < pos.length(); ++index) {
            if (Character.isLetter(pos.charAt(index))) continue;
            return index;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
    }

    @Deprecated
    public static int[] pos2XY(String pos) {
        int[] xy = new int[2];
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        xy[0] = ExcelUtils.pos2X(pos, colAxisIndex);
        xy[1] = ExcelUtils.pos2Y(pos, colAxisIndex);
        return xy;
    }

    public static Point pos2Point(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return new Point(ExcelUtils.pos2X(pos, colAxisIndex), ExcelUtils.pos2Y(pos, colAxisIndex));
    }

    public static boolean isBeforeRange(String rec1, String rec2) {
        RangeModel a = new RangeModel(rec1);
        RangeModel b = new RangeModel(rec2);
        return b.getX_end() < a.getX_start() && b.getY_start() >= a.getY_start() && b.getY_end() <= a.getY_end() || b.getY_end() < a.getY_start() && b.getX_start() >= a.getX_start() && b.getX_end() <= a.getX_end();
    }

    public static boolean isRowBeforeRange(String rec1, String rec2) {
        RangeModel a = new RangeModel(rec1);
        RangeModel b = new RangeModel(rec2);
        return b.getY_start() > a.getY_end();
    }

    public static boolean isColBeforeRange(String rec1, String rec2) {
        RangeModel a = new RangeModel(rec1);
        RangeModel b = new RangeModel(rec2);
        return b.getX_start() > a.getX_end();
    }

    public static boolean isOverlap(String rec1, String rec2) {
        RangeModel a = new RangeModel(rec1);
        RangeModel b = new RangeModel(rec2);
        return Math.max(a.getX_start(), b.getX_start()) <= Math.min(a.getX_end(), b.getX_end()) && Math.max(a.getY_start(), b.getY_start()) <= Math.min(a.getY_end(), b.getY_end());
    }

    public static String xy2Pos(int x, int y) {
        if (x < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"ExcelUtils_2", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        String xAxis = ExcelUtils.int2pos(x);
        return xAxis + (y + 1);
    }

    public static Collection<String> spiltToExcelIndex(List<Integer> indexs, boolean isRow) {
        ArrayList<String> collection = new ArrayList<String>(16);
        if (CollectionUtils.isNotEmpty(indexs)) {
            indexs.forEach(i -> {
                if (isRow) {
                    collection.add(ResManager.loadKDString((String)"%s\u884c", (String)"ExcelUtils_3", (String)"epm-epbs-common", (Object[])new Object[]{i + 1}));
                } else {
                    collection.add(ResManager.loadKDString((String)"%s\u5217", (String)"ExcelUtils_4", (String)"epm-epbs-common", (Object[])new Object[]{ExcelUtils.int2pos(i)}));
                }
            });
        }
        return collection;
    }

    public static String int2pos(int intVal) {
        if (intVal < 0) {
            return null;
        }
        ++intVal;
        char[] tmp = new char[30];
        int i = 29;
        while (i >= 0) {
            int q = intVal / 26;
            int r = intVal % 26;
            if (r < 1) {
                r = 26;
                --q;
            }
            tmp[i--] = (char)(65 + r - 1);
            if (q == 0) break;
            intVal = q;
        }
        return new String(tmp, ++i, tmp.length - i);
    }

    public static RangeModel calcRange(String startPos, String endPos, String dataPos, boolean isCalcColDim) {
        int endY;
        int startY;
        int endX;
        int startX;
        Point start = ExcelUtils.pos2Point(startPos);
        Point end = ExcelUtils.pos2Point(endPos);
        Point data = ExcelUtils.pos2Point(dataPos);
        if (isCalcColDim) {
            startX = data.x;
            endX = end.x;
            startY = start.y;
            endY = data.y - 1;
        } else {
            startX = start.x;
            endX = data.x - 1;
            startY = data.y;
            endY = end.y;
        }
        return new RangeModel(startX, endX, startY, endY);
    }

    public static String checkPosValidata(String startPos, String endPos, String dataPos) {
        StringBuilder msg = new StringBuilder();
        try {
            int startPosX = -1;
            int startPosY = -1;
            int endPosX = -1;
            int endPosY = -1;
            int dataPosX = -1;
            int dataPosY = -1;
            if (startPos != null) {
                startPosX = ExcelUtils.pos2X(startPos);
                startPosY = ExcelUtils.pos2Y(startPos);
            }
            if (endPos != null) {
                endPosX = ExcelUtils.pos2X(endPos);
                endPosY = ExcelUtils.pos2Y(endPos);
            }
            if (startPos != null && endPos != null && dataPos != null) {
                dataPosX = ExcelUtils.pos2X(dataPos);
                dataPosY = ExcelUtils.pos2Y(dataPos);
                if (dataPosX < startPosX || dataPosY < startPosY || dataPosX > endPosX || dataPosY > endPosY) {
                    msg.append(ResManager.loadKDString((String)"\u6570\u636e\u5f00\u59cb\u5355\u5143\u683c\u4e0d\u5728\u533a\u57df\u8303\u56f4\u5185!", (String)"ExcelUtils_5", (String)"epm-epbs-common", (Object[])new Object[0]));
                }
            } else if (startPos != null && endPos != null && (endPosX < startPosX || endPosY < startPosY)) {
                msg.append(ResManager.loadKDString((String)"\u533a\u57df\u8303\u56f4\u65e0\u6548\uff0c\u7ed3\u675f\u5355\u5143\u683c\u5fc5\u987b\u5728\u5f00\u59cb\u5355\u5143\u683c\u53f3\u4e0b\u65b9\u3002", (String)"ExcelUtils_6", (String)"epm-epbs-common", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            msg.append(e.getMessage());
        }
        return msg.toString();
    }

    public static String validateRange(String range) {
        if (range != null) {
            String[] split = range.split(":");
            if (split.length == 2) {
                return ExcelUtils.checkPosValidata(split[0], split[1], null);
            }
            if (split.length == 1) {
                return ExcelUtils.checkPosValidata(split[0], null, null);
            }
        }
        return null;
    }

    public static boolean isWithInScope(String areaRange, String startPosition) {
        String[] arrs = areaRange.split(":");
        return StringUtils.isEmpty((CharSequence)ExcelUtils.checkPosValidata(arrs[0], arrs.length == 1 ? arrs[0] : arrs[1], startPosition));
    }

    public static String[] calColAxisSerial(String areaRange) {
        RangeModel rangeModel = new RangeModel(areaRange);
        int colstart = rangeModel.getX_start();
        int colend = rangeModel.getX_end();
        ArrayList<String> colAxisSerial = new ArrayList<String>(colend - colstart + 1);
        for (int i = colstart; i <= colend; ++i) {
            colAxisSerial.add(ExcelUtils.int2pos(i));
        }
        return colAxisSerial.toArray(new String[0]);
    }

    public static String[] calRowAxisSerial(String areaRange) {
        RangeModel rangeModel = new RangeModel(areaRange);
        int rowstart = rangeModel.getY_start();
        int rowend = rangeModel.getY_end();
        ArrayList<String> colAxisSerial = new ArrayList<String>(rowend - rowstart + 1);
        for (int i = rowstart; i <= rowend; ++i) {
            colAxisSerial.add(String.valueOf(i + 1));
        }
        return colAxisSerial.toArray(new String[0]);
    }

    public static String offsetAxisByRow(String pos, int offset) {
        int y = ExcelUtils.pos2Y(pos);
        int x = ExcelUtils.pos2X(pos);
        return ExcelUtils.xy2Pos(x, y += offset);
    }

    public static String offsetAxisByCol(String pos, int offset) {
        int y = ExcelUtils.pos2Y(pos);
        int x = ExcelUtils.pos2X(pos);
        return ExcelUtils.xy2Pos(x += offset, y);
    }

    public static boolean checkCell(String area) {
        try {
            int[] rangeSxy = ExcelUtils.pos2XY(area.split(":")[0]);
            int[] rangeExy = ExcelUtils.pos2XY(area.split(":")[1]);
            int cc = rangeExy[0] - rangeSxy[0] + 1;
            int rc = rangeExy[1] - rangeSxy[1] + 1;
            if (cc == 0 || rc == 0) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (Exception e3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u5143\u683c\u8303\u56f4\u3002", (String)"ExcelUtils_7", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
    }
}

