/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.web.DispatchServiceHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.export.ExportHandler;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportUtil {
    public static final String EMPTY = "";
    public static final String TEMPLATETYPE = "templatetype";
    public static final String BOS_IMPORTTEMPLATE = "bos_importtemplate";
    public static final int FLUSH_TIMEOUT_SECOND = 300;
    private static final String[] SOURCES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String export(DynamicObject[] arrDimMapping, String routeAppId, String formId, ExportHandler handler) throws Exception {
        DynamicObject templateData = ExportUtil.getImportTemplate(formId);
        String fileName = ExportUtil.genFullFileName(templateData.getString("name"), EMPTY);
        return ExportUtil.export(arrDimMapping, templateData.get("id"), routeAppId, formId, fileName, handler);
    }

    public static String export(DynamicObject[] arrDimMapping, String routeAppId, String formId, String fileName) throws Exception {
        return ExportUtil.export(arrDimMapping, routeAppId, formId, fileName, null);
    }

    public static String export(DynamicObject[] arrDimMapping, String routeAppId, String formId, String fileName, ExportHandler handler) throws Exception {
        return ExportUtil.export(arrDimMapping, ExportUtil.getImportTemplateId(formId), routeAppId, formId, fileName, handler);
    }

    public static String export(DynamicObject[] arrDimMapping, Object template, String routeAppId, String formId, String fileName, ExportHandler handler) throws Exception {
        ExportWriterFormat format = ExportUtil.getExportWriterFormat(routeAppId, formId, template, formId);
        if (null == format) {
            return null;
        }
        if (null != handler) {
            handler.handlerFormat(format);
        }
        JSONArray billArr = JSON.parseArray((String)SerializationUtils.toJsonString((Object)arrDimMapping));
        if (null != handler) {
            handler.handlerBillDatas(billArr);
        }
        ListDataExporter exporter = ExportUtil.getExporter(formId, format);
        DynamicObjectType dataEntityType = (DynamicObjectType)arrDimMapping[0].getDataEntityType();
        int rowIndex = 4;
        try (TraceSpan span = Tracer.create((String)"epbsexport", (String)"export");){
            for (int i = 0; i < billArr.size(); ++i) {
                JSONObject bill = billArr.getJSONObject(i);
                if (bill == null) continue;
                exporter.handleData(bill, dataEntityType, arrDimMapping[i]);
                ExportUtil.billFormatConfig(bill);
                int offset = exporter.writeData(bill, rowIndex, format, false, fileName, false);
                rowIndex += Math.max(offset, 1);
            }
        }
        return exporter.flush(fileName, 300);
    }

    @SafeVarargs
    public static String export(String fileName, ThreeTuple<String, String[], List<String[]>> ... sheets) {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFCellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        for (ThreeTuple<String, String[], List<String[]>> sheet : sheets) {
            XSSFSheet xssfSheet = workBook.createSheet((String)sheet.item1);
            XSSFRow headerRow = xssfSheet.createRow(0);
            String[] columnNames = (String[])sheet.item2;
            for (int i = 0; i < columnNames.length; ++i) {
                XSSFCell cell = headerRow.createCell(i, CellType.STRING);
                cell.setCellValue(columnNames[i]);
                cell.setCellStyle((CellStyle)style);
            }
            List datas = (List)sheet.item3;
            for (int i = 0; i < datas.size(); ++i) {
                String[] row = (String[])datas.get(i);
                int rowIndex = i + 1;
                XSSFRow xssfRow = xssfSheet.createRow(rowIndex);
                for (int j = 0; j < row.length; ++j) {
                    XSSFCell cell = xssfRow.createCell(j, CellType.STRING);
                    cell.setCellValue(row[j]);
                }
            }
        }
        try {
            return ExportUtil.writeFile((Workbook)workBook, fileName);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static ListDataExporter getExporter(String formId, ExportWriterFormat format) {
        ListDataExporter exporter = new ListDataExporter(formId, (List)Lists.newArrayList((Object[])new ExportWriterFormat[]{format}), false, formId);
        return exporter;
    }

    public static ExportWriterFormat getExportWriterFormat(String routeAppId, Object formId, Object template, Object extendData) {
        ExportWriterFormat format = ExportUtil.buildWriterFormat(routeAppId, formId, template, extendData, ExportWriterFormat.class);
        return format;
    }

    public static void billFormatConfig(JSONObject bill) {
        for (Map.Entry billEntry : bill.entrySet()) {
            if (!(billEntry.getValue() instanceof BigDecimal) || !bill.containsKey(billEntry.getKey())) continue;
            bill.put((String)billEntry.getKey(), (Object)((BigDecimal)billEntry.getValue()).stripTrailingZeros());
        }
    }

    public static Object getImportTemplateId(String formId) {
        DynamicObject templateData = ExportUtil.getImportTemplate(formId);
        return templateData.get("id");
    }

    public static DynamicObject getImportTemplate(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("bizobject.number", "=", (Object)formId), new QFilter(TEMPLATETYPE, "=", (Object)"IMPT").or(new QFilter(TEMPLATETYPE, "is null", null))};
        DynamicObject templateData = QueryServiceHelper.queryOne((String)BOS_IMPORTTEMPLATE, (String)"id,name", (QFilter[])filters);
        if (templateData == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5f15\u5165\u5f15\u51fa\u6a21\u677f\uff01", (String)"ExportUtil_1", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        return templateData;
    }

    public static String genFullFileName(String templateName, String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(templateName);
        LocalDate now = LocalDate.now();
        sb.append(String.format("_%4d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()));
        sb.append(".xlsx");
        return sb.toString();
    }

    public static String appendXlsx(String fileName) {
        if (null != fileName && !fileName.endsWith(".xlsx")) {
            fileName = fileName + ".xlsx";
        }
        return fileName;
    }

    public static String genFileName(Long template, String billFormId, String fileNamePrefix) {
        StringBuilder fileName = new StringBuilder(fileNamePrefix);
        DynamicObject templateData = null;
        if (template > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)BOS_IMPORTTEMPLATE);
        }
        if (templateData != null) {
            fileName.append(templateData.get("name"));
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
            fileName.append(listEntityType.getDisplayName());
        }
        LocalDate now = LocalDate.now();
        fileName.append(String.format("_%4d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()));
        return fileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(Workbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ExportUtil.appendXlsx(fileName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static <T> T buildWriterFormat(String routeAppId, Object formId, Object template, Object extendData, Class<T> formatType) {
        Object format = null;
        String exportJson = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, template, EMPTY, extendData});
        if (!kd.bos.util.StringUtils.isEmpty((String)exportJson) && exportJson.startsWith("[")) {
            List formatArr = JSON.parseArray((String)exportJson, formatType);
            if (formatArr != null && !formatArr.isEmpty()) {
                format = formatArr.get(0);
            }
        } else {
            format = JSON.parseObject((String)exportJson, formatType);
        }
        return (T)format;
    }

    public static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append("Z");
            remainder = 26;
        } else {
            sb.append(SOURCES[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(SOURCES[remainder]);
        }
        return sb.reverse().toString();
    }

    public static void exportByBillList(IFormView formView, boolean isAll, QFilter qf) {
        BillList billList = (BillList)formView.getControl("billlistap");
        String billFormId = billList.getBillFormId();
        Long modelId = 0L;
        try {
            if (!isAll && CollectionUtils.isEmpty((Collection)billList.getSelectedRows())) {
                formView.showTipNotification(OperationMsgUtil.getBillRowTip());
                return;
            }
            Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
            if (isAll) {
                ids = QueryServiceHelper.queryPrimaryKeys((String)billFormId, (QFilter[])(qf != null ? qf.toArray() : null), null, (int)-1).toArray();
            }
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billFormId));
            try {
                String url = ExportUtil.export(load, AppTypeEnum.EPBS.getAppId(), billFormId, MetadataServiceHelper.getDataEntityType((String)billFormId).getDisplayName().getLocaleValue());
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            Optional<IDataEntityProperty> options = formView.getModel().getDataEntityType().getProperties().stream().filter(e -> e instanceof BasedataProp && ((BasedataProp)e).getBaseEntityId().equals("epbs_model")).findFirst();
            if (options.isPresent()) {
                options.get().getName();
                DynamicObject d = (DynamicObject)formView.getModel().getValue(options.get().getName());
                modelId = d == null ? 0L : d.getLong("id");
            }
            OperationLogUtil.writeLog(billFormId, OperationTypeEnum.EXPORT, OperationMsgUtil.getSucStatus(), modelId);
        }
        catch (Exception e3) {
            OperationLogUtil.writeLog(billFormId, OperationTypeEnum.IMPORT, OperationMsgUtil.getFailStatus(), modelId);
            formView.showTipNotification(OperationMsgUtil.getExportFailMsg(e3.getMessage()));
        }
    }
}

