/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import org.apache.commons.lang.StringUtils;

public class IDUtils {
    public static <T> Long toLong(T t) {
        if (t instanceof Long) {
            return (Long)t;
        }
        if (t == null) {
            return 0L;
        }
        return IDUtils.toLong(t.toString());
    }

    private static Long toLong(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return 0L;
        }
        if (StringUtils.isNumeric((String)id)) {
            return Long.valueOf(id);
        }
        return 0L;
    }

    public static <T> Long toLong2(T id) {
        if (id instanceof DynamicObject) {
            return IDUtils.toLong(((DynamicObject)id).getPkValue());
        }
        return IDUtils.toLong(id);
    }

    public static <T> List<Long> toLongs(List<T> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> _ids = new ArrayList<Long>(ids.size());
        for (T id : ids) {
            _ids.add(IDUtils.toLong(id));
        }
        return _ids;
    }

    public static <T> List<Long> toLongs(Collection<T> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> _ids = new ArrayList<Long>(ids.size());
        for (T id : ids) {
            _ids.add(IDUtils.toLong(id));
        }
        return _ids;
    }

    public static <T> Set<Long> toLongs(Set<T> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> _ids = new HashSet<Long>(ids.size());
        for (T id : ids) {
            _ids.add(IDUtils.toLong(id));
        }
        return _ids;
    }

    public static List<Long> toLongs(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> _ids = new ArrayList<Long>(ids.length);
        for (Object id : ids) {
            _ids.add(IDUtils.toLong(id));
        }
        return _ids;
    }

    public static <T> String toString(T id) {
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    public static List<String> toStrings(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> _ids = new ArrayList<String>(ids.size());
        for (Long id : ids) {
            _ids.add(id.toString());
        }
        return _ids;
    }

    public static Set<String> toStringCollection(Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> _ids = new HashSet<String>(ids.size());
        for (Long id : ids) {
            if (id == null) continue;
            _ids.add(id.toString());
        }
        return _ids;
    }

    public static Boolean isEmptyLong(Long _longVal) {
        return _longVal == null || _longVal == 0L;
    }

    public static Boolean isNotEmptyLong(Long _longVal) {
        return IDUtils.isEmptyLong(_longVal) == false;
    }

    public static Boolean isEmptyObj(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Long) {
            return ((Long)obj).equals(0L);
        }
        return false;
    }

    public static boolean isNull(Long id) {
        return id == null || id == 0L;
    }

    public static boolean isNull(long id) {
        return id == 0L;
    }

    public static boolean isNotNull(Long id) {
        return id != null && id != 0L;
    }

    public static boolean isNotNull(long id) {
        return id != 0L;
    }

    public static <T> boolean equals(T id1, T id2) {
        return IDUtils.toLong(id1).equals(IDUtils.toLong(id2));
    }
}

