/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportAndExportUtil {
    @SafeVarargs
    public static String export(String fileName, ThreeTuple<String, String[], List<String[]>> ... sheets) {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFCellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        for (ThreeTuple<String, String[], List<String[]>> sheet : sheets) {
            XSSFSheet xssfSheet = workBook.createSheet((String)sheet.item1);
            XSSFRow headerRow = xssfSheet.createRow(0);
            String[] columnNames = (String[])sheet.item2;
            for (int i = 0; i < columnNames.length; ++i) {
                XSSFCell cell = headerRow.createCell(i, CellType.STRING);
                cell.setCellValue(columnNames[i]);
                cell.setCellStyle((CellStyle)style);
            }
            List datas = (List)sheet.item3;
            for (int i = 0; i < datas.size(); ++i) {
                String[] row = (String[])datas.get(i);
                int rowIndex = i + 1;
                XSSFRow xssfRow = xssfSheet.createRow(rowIndex);
                for (int j = 0; j < row.length; ++j) {
                    XSSFCell cell = xssfRow.createCell(j, CellType.STRING);
                    cell.setCellValue(row[j]);
                }
            }
        }
        try {
            return ImportAndExportUtil.writeFile(workBook, fileName);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(XSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

