/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImportUtil {
    private static Log log = LogFactory.getLog(ImportUtil.class);

    public static List<InputStream> getImportStreams(List<String> fileUrls) {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        try {
            for (String url : fileUrls) {
                String[] reqParams = new URL(url).getQuery().split("&");
                HashMap<String, String> map = new HashMap<String, String>(4);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                if (content == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ImportUtil_1", (String)"epm-epbs-common", (Object[])new Object[0]));
                }
                InputStream inputStream = content.getInputStream();
                inputStreams.add(inputStream);
            }
        }
        catch (MalformedURLException e) {
            log.error((Throwable)e);
        }
        return inputStreams;
    }

    public static List<String> getImportString(List<String> fileUrls) {
        ArrayList<String> importStringList = new ArrayList<String>(fileUrls.size());
        List<InputStream> importStreams = ImportUtil.getImportStreams(fileUrls);
        for (InputStream importStream : importStreams) {
            InputStreamReader inputStreamReader = new InputStreamReader(importStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                importStringList.add(stringBuilder.toString());
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            finally {
                try {
                    bufferedReader.close();
                    importStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return importStringList;
    }
}

