/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class JSONUtils {
    private static final Log log = LogFactory.getLog(JSONUtils.class);
    public static final ObjectMapper mapper = new ObjectMapper();
    public static final JavaType strType = JSONUtils.getMapper().getTypeFactory().constructType(String.class);

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static String toString(Object object) {
        String jsonStr = null;
        try {
            jsonStr = mapper.writeValueAsString(object);
        }
        catch (Throwable ex) {
            log.error("toJSONString error:", ex);
        }
        return jsonStr;
    }

    public static String toJson(Object object, DateFormat format) {
        mapper.setDateFormat(format);
        String jsonStr = null;
        try {
            jsonStr = mapper.writeValueAsString(object);
        }
        catch (Throwable ex) {
            log.error("toJSONString error:", ex);
        }
        return jsonStr;
    }

    public static <T> T parse(String jsonStr, Class<T> valueType) {
        if (jsonStr == null || jsonStr.trim().length() == 0) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonStr, valueType);
        }
        catch (IOException ex) {
            log.error("parse JSONString error:", (Throwable)ex);
            return null;
        }
    }

    public static <T> T parse(String jsonStr, JavaType javaType) {
        if (jsonStr == null || jsonStr.trim().length() == 0 || javaType == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonStr, javaType);
        }
        catch (IOException ex) {
            log.error("parse JSONString error:", (Throwable)ex);
            return null;
        }
    }

    public static <T> T parse(String jsonString, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(jsonString, typeReference);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    public static <T> T parseFormMap(Map map, Class<?> clazz) {
        return (T)JSONUtils.parse(JSONUtils.toString(map), clazz);
    }

    public static String toJSON(String fName, Object value) {
        StringBuilder json = new StringBuilder();
        json.append('\"').append(fName).append("\":");
        json.append(JSON.toJSONString((Object)value));
        return json.toString();
    }

    public static <T> List<T> parseArray(String str, Class<?> clazz) {
        try {
            return (List)mapper.readValue(str, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (Exception e) {
            log.error("parse JSONString error:", (Throwable)e);
            return null;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

