/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.model.Dimension;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppModelEnum;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.AppUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ModelUtil {
    private static final Log LOG = LogFactory.getLog(ModelUtil.class);
    public static final String ModelSelectFields = "id,number,name,shownumber,description,modifier,modifytime,creator,createtime,status,enable,datasource";

    public static List<AppModelEnum> getAppModelByEnum(Collection<AppTypeEnum> appTypes) {
        List<AppModelEnum> appModels;
        HashSet<String> apps = new HashSet<String>(AppUtils.getAppNumsCache());
        if (appTypes != null) {
            apps.removeIf(e -> appTypes.stream().noneMatch(a -> a.getAppNum().equalsIgnoreCase((String)e)));
        }
        if (CollectionUtils.isEmpty(appModels = Arrays.stream(AppModelEnum.values()).filter(e -> apps.contains(e.getAppType().getAppNum()) && StringUtils.isNotEmpty((String)e.getModelEntity())).sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList()))) {
            LOG.error(String.format("\u5f53\u524d\u540c\u6b65\u7684\u5e94\u7528\uff1a%s. \u5f53\u524d\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9:%s", apps, AppModelEnum.CM.getModelEntity()));
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5b58\u5728\u5e94\u7528\uff0c\u8bf7\u5148\u8fdb\u884c\u5e94\u7528\u5347\u7ea7\u3002", (String)"ModelUtil_1", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        return appModels;
    }

    public static DynamicObjectCollection queryEpbsModel(QFilter filter) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)"epbs_model", (String)"id,number,name,shownumber,description,modifier,modifytime,creator,createtime,status,enable,datasource,srcappnum", (QFilter[])filter.toArray());
        return list;
    }

    public static DynamicObject loadAppModel(Long modelId, String appnum) {
        AppModelEnum appModel = AppModelEnum.getByNumber(appnum);
        if (StringUtils.isEmpty((String)appModel.getModelEntity())) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)modelId, (String)appModel.getModelEntity());
    }

    public static List<DynamicObject> loadAppModel(Collection<Long> modelIds, String appnum) {
        AppModelEnum appModel = AppModelEnum.getByNumber(appnum);
        if (StringUtils.isEmpty((String)appModel.getModelEntity())) {
            return null;
        }
        return Arrays.stream(BusinessDataServiceHelper.load((String)appModel.getModelEntity(), (String)ModelSelectFields, (QFilter[])new QFilter("id", "in", modelIds).toArray())).collect(Collectors.toList());
    }

    public static AppTypeEnum getAppType(Long modelId) {
        return AppTypeEnum.getEnumByAppnum(((ModelBean)ModelCacheHelper.getModel(modelId)).getSrcAppNum());
    }

    public static Map<String, DynamicObject> getDimMemberDyn(Long modelId, Dimension dimension, Collection memberNums) {
        ArrayList<QFilter> memberFilters = new ArrayList<QFilter>(4);
        memberFilters.add(new QFilter("model", "=", (Object)modelId));
        if (memberNums.size() < 100) {
            memberFilters.add(new QFilter("number", "in", (Object)memberNums));
        }
        memberFilters.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        Map<String, DynamicObject> members = BusinessDataServiceHelper.loadFromCache((String)dimension.getMemberTreemodel(), (String)"id,number,name", (QFilter[])memberFilters.toArray(new QFilter[0])).values().stream().collect(Collectors.toMap(doj -> doj.getString("number"), doj -> doj, (k1, k2) -> k1));
        return members;
    }

    public static String getMemberInfoStr(String memberNumber, DynamicObject memberDoj) {
        if (StringUtils.isEmpty((String)memberNumber)) {
            return "";
        }
        String name = memberDoj != null ? memberDoj.getString("name") : null;
        String info = Joiner.on((String)",").join((Object)memberNumber, (Object)(null != name ? name : ""), new Object[0]);
        return info;
    }
}

