/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.UserUtils;

public class MutexServiceHelper {
    public static final String MUTEX_DATAOBJID = "dataObjId";
    public static final String MUTEX_GROUPID = "groupId";
    public static final String MUTEX_ENTITYKEY = "entityKey";
    public static final String MUTEX_OPERATIONKEY = "operationKey";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean request(String id, String entityKey, String opKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.require(id, "op_" + opKey, entityKey, opKey, true);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean release(String id, String entityKey, String operationKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.release(id, entityKey, operationKey);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(String id, String entityKey, String opKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map map = dataMutex.getLockInfo(id, "op_" + opKey, entityKey);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean forceRelease(String id, String entityKey, String operationKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.forcerelease(id, entityKey, operationKey);
            return bl;
        }
        catch (IOException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s|%2$s|%3$s]\u5f3a\u5236\u91ca\u653e\u9501\u5931\u8d25\u3002", (String)"MutexServiceHelper_1", (String)"epm-epbs-common", (Object[])new Object[0]), id, entityKey, operationKey));
        }
    }

    public static Optional<String> requestMutex(String pkId, String entityId, String opKey) {
        String mutexKey = pkId + "";
        Map<String, String> lockInfo = MutexServiceHelper.getLockInfo(mutexKey, entityId, opKey);
        if (lockInfo == null) {
            boolean success = MutexServiceHelper.request(mutexKey, entityId, opKey);
            if (!success) {
                return Optional.of(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\u3002", (String)"MutexServiceHelper_2", (String)"epm-epbs-common", (Object[])new Object[0]));
            }
        } else if (!RequestContext.getOrCreate().getUserId().equals(lockInfo.get("userid"))) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u5df2\u88ab%s\u9501\u5b9a\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"MutexServiceHelper_3", (String)"epm-epbs-common", (Object[])new Object[0]), UserUtils.getUserName(IDUtils.toLong(lockInfo.get("userid")))));
        }
        return Optional.empty();
    }
}

