/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.util.AppVersionUtils;
import kd.epm.epbs.common.util.TXUtils;

public class NoticeUserHelper {
    public static boolean isNeedNoticeUser(String appNum, String version) {
        return version.compareToIgnoreCase(NoticeUserHelper.getNoticeUserVersion(appNum)) > 0;
    }

    public static String getNoticeUserVersion(String appNum) {
        return (String)ThreadCache.get((Object)"", () -> {
            long currentUserId = RequestContext.get().getCurrUserId();
            QFilter qFilter = new QFilter("user", "=", (Object)currentUserId);
            qFilter.and("appnum", "=", (Object)appNum);
            return QueryServiceHelper.query((String)"epbs_upgrade_noticeuser", (String)"version", (QFilter[])qFilter.toArray()).stream().map(e -> e.getString("version")).findFirst().orElseGet(() -> "0");
        });
    }

    public static void saveRecord(String appNum, String version) {
        long currentUserId = RequestContext.get().getCurrUserId();
        TXUtils.required(tx -> {
            QFilter qFilter = new QFilter("user", "=", (Object)currentUserId);
            qFilter.and("appnum", "=", (Object)appNum);
            DeleteServiceHelper.delete((String)"epbs_upgrade_noticeuser", (QFilter[])qFilter.toArray());
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_upgrade_noticeuser");
            dy.set("user", (Object)currentUserId);
            dy.set("appnum", (Object)appNum);
            dy.set("version", (Object)version);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        });
    }

    public static void saveRecord(String appNum) {
        NoticeUserHelper.saveRecord(appNum, AppVersionUtils.getCurVersion(appNum));
    }
}

