/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.function.Supplier;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.util.CodeRuleUtil;

public class NumberGenHelper {
    private String entityNumber;
    private String suffix = "-copy";
    private TextProp numberProp;

    public NumberGenHelper(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String genCode() {
        DynamicObject dynamicObject;
        ICodeRuleService codeRuleService = CodeRuleUtil.getCodeRuleService();
        CodeRuleInfo codeRule = codeRuleService.getCodeRule(this.entityNumber, dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityNumber), null);
        if (codeRule != null) {
            return codeRuleService.getNumber(codeRule, dynamicObject);
        }
        return null;
    }

    public String copyCode(String number) {
        return this.copyCodeWithDefault(number, () -> null);
    }

    public String copyCodeWithDefault(String number, Supplier<String> supplier) {
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)this.entityNumber);
        String numberProperty = dataEntityType.getNumberProperty();
        this.numberProp = (TextProp)dataEntityType.findProperty(numberProperty);
        String copy = this.copy(number, this.numberProp.getMaxLenth());
        if (copy == null && supplier != null) {
            return supplier.get();
        }
        return copy;
    }

    protected String copy(String number, int maxSize) {
        String newNumber = (number.length() >= maxSize - 5 ? number.substring(0, maxSize - 5) : number) + this.suffix;
        if (QueryServiceHelper.exists((String)this.entityNumber, (QFilter[])new QFilter("number", "=", (Object)newNumber).toArray())) {
            if (maxSize > newNumber.length()) {
                for (int i = 0; i < maxSize - newNumber.length(); ++i) {
                    if (QueryServiceHelper.exists((String)this.entityNumber, (QFilter[])new QFilter("number", "=", (Object)(newNumber + i)).toArray())) continue;
                    return newNumber + i;
                }
            } else if (maxSize > 10) {
                return this.copy(number, maxSize - 1);
            }
            return null;
        }
        return newNumber;
    }
}

