/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.form.IFormView;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class NumberRuleUtils {
    public static boolean checkNumber(String number) {
        String regEx = "^(?!_)[A-Za-z0-9_-]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches() && !number.startsWith(".") && !number.startsWith("_");
    }

    public static String getMessage() {
        return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"NumberRuleUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]);
    }

    public static boolean checkNumber(IFormView formView) {
        BasedataEntityType dataEntityType;
        String number = "number";
        if (formView instanceof BaseView && (number = (dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)formView.getEntityId())).getNumberProperty()) == null) {
            return true;
        }
        String val = (String)formView.getModel().getValue(number);
        if (StringUtils.isEmpty((String)val)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NumberRuleUtils_5", (String)"epm-epbs-common", (Object[])new Object[0]));
            return false;
        }
        if (!NumberRuleUtils.checkNumber(val)) {
            formView.showTipNotification(NumberRuleUtils.getMessage());
            return false;
        }
        return true;
    }

    public static boolean checkIfRepeat(BaseView baseView) {
        Optional<String> optional;
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseView.getEntityId());
        String number = dataEntityType.getNumberProperty();
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        DynamicObject dy = baseView.getModel().getDataEntity();
        QFilter qFilter = new QFilter(number, "=", (Object)dy.getString(number));
        if (baseView.getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            qFilter.and("id", "!=", dy.get(dataEntityType.getPrimaryKey().getName()));
        }
        if ((optional = NumberRuleUtils.checkIfRepeat(dataEntityType.getName(), qFilter.toArray())).isPresent()) {
            baseView.showTipNotification(optional.get());
            return true;
        }
        return false;
    }

    public static Optional<String> checkIfRepeat(String entityNumber, String numberval, Object pkId) {
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber);
        QFilter qFilter = new QFilter(dataEntityType.getNumberProperty(), "=", (Object)numberval);
        qFilter.and("id", "!=", pkId);
        return NumberRuleUtils.checkIfRepeat(entityNumber, qFilter.toArray());
    }

    public static Optional<String> checkIfRepeat(String entityNumber, QFilter[] qFilters) {
        if (QueryServiceHelper.exists((String)entityNumber, (QFilter[])qFilters)) {
            return Optional.of(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"NumberRuleUtils_4", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public static boolean checkBillNumber(IFormView view, String entityNumber, Object pkId) {
        if (NumberRuleUtils.checkNumber(view)) {
            Optional<String> s;
            QFilter qFilter = new QFilter("number", "=", (Object)((String)view.getModel().getValue("number")));
            if (pkId != null) {
                qFilter.and("id", "!=", pkId);
            }
            if ((s = NumberRuleUtils.checkIfRepeat(entityNumber, qFilter.toArray())).isPresent()) {
                view.showTipNotification(s.get());
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean checkShortNumber(String number) {
        String regEx = "^[A-Za-z]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches();
    }

    public static String getShrotNumberMessage() {
        return ResManager.loadKDString((String)"\u7b80\u7801\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"NumberRuleUtils_2", (String)"epm-epbs-common", (Object[])new Object[0]);
    }

    public static boolean checkNumberV2(String number) {
        String regEx = "^(?!_)[A-Za-z0-9_.-]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches() && !number.startsWith(".") && !number.startsWith("_") && !number.contains("..") && NumberRuleUtils.checkKeyWords(number);
    }

    public static String getMessageV2() {
        return ResManager.loadKDString((String)"\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u4ee5\u53ca\u591a\u7ef4\u5e93\u4fdd\u7559\u5b57\u6bb5all\u3001other\u3001none\uff08\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff0c\u6700\u957f50\u4e2a\u5b57\u7b26\uff09\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"NumberRuleUtils_3", (String)"epm-epbs-common", (Object[])new Object[0]);
    }

    public static boolean checkKeyWords(String number) {
        boolean flag = true;
        if (number.equalsIgnoreCase("all") || number.equalsIgnoreCase("other") || number.equalsIgnoreCase("none") || number.equalsIgnoreCase("null")) {
            flag = false;
        }
        return flag;
    }
}

