/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import kd.bos.lang.Lang;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapConnectionStringBuilder;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.ds.DataConnectCacheUtil;
import kd.epm.epbs.common.ds.DatasourceModel;
import kd.epm.epbs.common.util.EncryptUtils;

public class OlapConnectionBuilderWrapper {
    public static final int SHREK_CONN_TIMEOUT = 10000;
    private String provider = "kingdee.olap.Shrek";
    private String modelCube;
    private String forTest = "false";
    private Boolean nestedOpenClose;
    private String applicationName;
    private String connectionString;
    private String tenantId;
    private Integer timeout = 10000;
    private Long modelId;

    public OlapConnectionBuilderWrapper(String modelCube) {
        this.modelCube = modelCube;
    }

    public OlapConnectionBuilderWrapper() {
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setModelCube(String modelCube) {
        this.modelCube = modelCube;
    }

    public void setForTest(String forTest) {
        this.forTest = forTest;
    }

    public void setNestedOpenClose(Boolean nestedOpenClose) {
        this.nestedOpenClose = nestedOpenClose;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public OlapConnection getOlapConnection() {
        DatasourceModel ds = DataConnectCacheUtil.getDataSourceCache(this.modelCube, this.modelId);
        return this.getOlapConnection(ds);
    }

    public OlapConnection getEmptyOlapConnection() {
        DatasourceModel ds = DataConnectCacheUtil.getDataSourceCache(this.modelCube, this.modelId);
        return this.getEmptyOlapConnection(ds);
    }

    public OlapConnection getOlapConnection(DatasourceModel ds) {
        OlapConnectionStringBuilder connBuilder = new OlapConnectionStringBuilder();
        connBuilder.setProvider(this.provider);
        if (this.nestedOpenClose != null) {
            connBuilder.setNestedOpenClose(this.nestedOpenClose.booleanValue());
        }
        if (StringUtils.isNotEmpty((String)this.applicationName)) {
            connBuilder.setApplicationName(this.applicationName);
        }
        if (StringUtils.isNotEmpty((String)this.connectionString)) {
            connBuilder.setConnectionString(this.connectionString);
        }
        if (StringUtils.isNotEmpty((String)this.tenantId)) {
            connBuilder.setTenantId(this.tenantId);
        }
        if (this.timeout != null) {
            connBuilder.setTimeout(this.timeout.intValue());
        }
        connBuilder.setInitialCatalog(this.modelCube);
        connBuilder.setForTest(this.forTest);
        connBuilder.setLanguage(Lang.get().equals((Object)Lang.zh_CN) || Lang.get().equals((Object)Lang.zh_TW) ? "zh" : "en");
        connBuilder.setDataSource(ds.getAddress());
        OlapConnection conn = new OlapConnection(connBuilder.toString());
        String password = ds.getPassword();
        password = EncryptUtils.aesDecrypt(password);
        conn.setUserName(EncryptUtils.aesDecrypt(ds.getUsername()));
        conn.setPassword(password);
        return conn;
    }

    public OlapConnection getEmptyOlapConnection(DatasourceModel ds) {
        OlapConnectionStringBuilder connBuilder = new OlapConnectionStringBuilder();
        connBuilder.setProvider(this.provider);
        if (this.nestedOpenClose != null) {
            connBuilder.setNestedOpenClose(this.nestedOpenClose.booleanValue());
        }
        if (StringUtils.isNotEmpty((String)this.applicationName)) {
            connBuilder.setApplicationName(this.applicationName);
        }
        if (StringUtils.isNotEmpty((String)this.connectionString)) {
            connBuilder.setConnectionString(this.connectionString);
        }
        if (StringUtils.isNotEmpty((String)this.tenantId)) {
            connBuilder.setTenantId(this.tenantId);
        }
        if (this.timeout != null) {
            connBuilder.setTimeout(this.timeout.intValue());
        }
        connBuilder.setForTest(this.forTest);
        connBuilder.setLanguage(Lang.get().equals((Object)Lang.zh_CN) || Lang.get().equals((Object)Lang.zh_TW) ? "zh" : "en");
        connBuilder.setDataSource(ds.getAddress());
        OlapConnection conn = new OlapConnection(connBuilder.toString());
        String password = ds.getPassword();
        password = EncryptUtils.aesDecrypt(password);
        conn.setUserName(EncryptUtils.aesDecrypt(ds.getUsername()));
        conn.setPassword(password);
        return conn;
    }
}

