/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ReflectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class OperationLogUtil {
    private static final Log log = LogFactory.getLog(OperationLogUtil.class);
    private static Class<? extends AppLogInfo> clazz = null;
    public static Class bridgeClazz = null;
    private static final String APP_ID = "epbs";

    @Deprecated
    public static void writeLog(String appId, String formId, IOperationTypeInfo opTypeInfo, MultiLangEnumBridge opDescriotion) {
        OperationLogUtil.writeLog(appId, formId, opTypeInfo, opDescriotion, "");
    }

    public static void writeLog(String appId, String formId, IOperationTypeInfo opTypeInfo, MultiLangEnumBridge opDescriotion, Long modelId) {
        String keyword = null;
        if (IDUtils.isNotNull(modelId)) {
            keyword = ((ModelBean)ModelCacheHelper.getModel(modelId)).getShowNumber();
        }
        OperationLogUtil.writeLog(appId, formId, opTypeInfo, opDescriotion, keyword);
    }

    @Deprecated
    public static void writeLog(String formId, IOperationTypeInfo opTypeInfo, MultiLangEnumBridge opDescriotion) {
        OperationLogUtil.writeLog(null, formId, opTypeInfo, opDescriotion, "");
    }

    public static void writeLog(String appId, String formId, IOperationTypeInfo opTypeInfo, MultiLangEnumBridge opDescriotion, String keyword) {
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            AppLogInfo logInfo = OperationLogUtil.buildLogInfo(appId, formId, opTypeInfo, opDescriotion, keyword);
            logService.addLog(logInfo);
        }
        catch (Exception e) {
            log.error("operationLogUtils.writelog fail:" + e.getMessage());
        }
    }

    @Deprecated
    public static void writeLog(String formId, IOperationTypeInfo opTypeInfo, MultiLangEnumBridge opDescriotion, Long modelId) {
        OperationLogUtil.writeLog(null, formId, opTypeInfo, opDescriotion, modelId);
    }

    public static AppLogInfo createLogInfo() {
        RequestContext rc = RequestContext.get();
        AppLogInfo logInfo = null;
        logInfo = clazz == null ? new AppLogInfo() : ReflectUtils.newInstance(clazz);
        logInfo.setUserID(Long.valueOf(rc.getCurrUserId()));
        logInfo.setOrgID(Long.valueOf(rc.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(rc.getClient());
        logInfo.setClientIP(rc.getLoginIP());
        logInfo.setClientName(rc.getClient());
        return logInfo;
    }

    private static AppLogInfo buildLogInfo(String appId, String bizEntityNumber, IOperationTypeInfo opTypeInfo, MultiLangEnumBridge opDescription, String keyword) {
        AppLogInfo logInfo = OperationLogUtil.createLogInfo();
        if (appId == null) {
            try {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bizEntityNumber);
                appId = dataEntityType.getAppId();
            }
            catch (Exception e) {
                appId = APP_ID;
            }
        }
        logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)appId).getId());
        logInfo.setBizObjID(bizEntityNumber);
        if (clazz != null) {
            try {
                if (StringUtils.isNotEmpty((String)keyword)) {
                    MethodUtils.invokeMethod((Object)logInfo, (String)"setKeyWord", (Object)keyword);
                }
                if (opDescription != null) {
                    String[] args = null;
                    if (opDescription.getArgs() != null && opDescription.getArgs().length > 0) {
                        args = new String[opDescription.getArgs().length];
                        for (int i = 0; i < opDescription.getArgs().length; ++i) {
                            Object arg = opDescription.getArgs()[i];
                            args[i] = arg == null ? null : arg.toString();
                        }
                    }
                    MethodUtils.invokeMethod((Object)logInfo, (String)"setOpDesc", (Object[])new Object[]{opDescription.transformBosBridge(), args}, (Class[])new Class[]{bridgeClazz, new String[0].getClass()});
                }
                if (opTypeInfo.getName() instanceof MultiLangEnumBridge) {
                    MethodUtils.invokeMethod((Object)logInfo, (String)"setOpName", (Object[])new Object[]{opTypeInfo.getOpKey(), ((MultiLangEnumBridge)opTypeInfo.getName()).transformBosBridge()});
                } else {
                    MethodUtils.invokeMethod((Object)logInfo, (String)"setOpName", (Object[])new Object[]{opTypeInfo.getOpKey(), opTypeInfo.getName()});
                }
                return logInfo;
            }
            catch (Exception e) {
                log.error("operationLogUtils\uff1a" + e.getMessage());
            }
        }
        logInfo.setOpName(opTypeInfo.getNameString());
        if (StringUtils.isNotEmpty((String)keyword) && opDescription != null) {
            String jointDesc = keyword + " " + opDescription.loadKDString();
            logInfo.setOpDescription(jointDesc);
        }
        return logInfo;
    }

    public static String getOpDescription(AppLogInfo applogInfo) {
        String opDescription = applogInfo.getOpDescription();
        try {
            String tt;
            if (kd.bos.util.StringUtils.isNotEmpty((String)opDescription) && clazz != null && applogInfo.getClass().isAssignableFrom(clazz) && kd.bos.util.StringUtils.isNotEmpty((String)(tt = (String)MethodUtils.invokeMethod((Object)applogInfo, (String)"getOpDescArgs", null)))) {
                Object[] o = (String[])SerializationUtils.fromJsonString((String)tt, new String[0].getClass());
                opDescription = String.format(opDescription, o);
            }
        }
        catch (Exception e) {
            log.error("operationLogUtils.getOpDescription\uff1a" + e.getMessage());
        }
        return opDescription;
    }

    static {
        String str = "kd.bos.log.api.OpLogAppInfo";
        if (ReflectUtils.isClazz(str)) {
            clazz = ReflectUtils.getClazz(str);
        }
        if (ReflectUtils.isClazz("kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge")) {
            bridgeClazz = ReflectUtils.getClazz("kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge");
        }
    }
}

