/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OperationResultUtil {
    public static void showOperationResult(IFormView formView, OperationResult operationResult) {
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        if (!validateErrors.isEmpty() || !operationResult.getAllErrorInfo().isEmpty()) {
            formView.showOperationResult(operationResult);
        } else {
            formView.showTipNotification(operationResult.getMessage());
        }
    }

    public static void throwOperationResult(OperationResult operationResult) {
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        if (!validateErrors.isEmpty()) {
            throw new KDBizException(validateErrors.stream().map(o -> {
                List allErrorInfo = o.getAllErrorInfo();
                if (!allErrorInfo.isEmpty()) {
                    return allErrorInfo.stream().map(OperateInfo::getMessage).collect(Collectors.joining("\n"));
                }
                return o.getMessage();
            }).collect(Collectors.joining("\n")));
        }
        if (!operationResult.getAllErrorInfo().isEmpty()) {
            throw new KDBizException(operationResult.getAllErrorInfo().stream().map(OperateInfo::getMessage).collect(Collectors.joining("\n")));
        }
        throw new KDBizException(operationResult.getMessage());
    }

    public static void executeOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            OperationResultUtil.throwOperationResult(operationResult);
        }
    }
}

