/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.epm.epbs.common.util.Filter;
import org.apache.commons.lang3.StringUtils;

public class PackageScanner {
    public static <T> Set<Class<? extends T>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotation, ClassLoader classLoader) {
        return PackageScanner.scanPackage(packageName, clazz -> clazz != null && clazz.isAnnotationPresent(annotation), classLoader);
    }

    public static <T> Set<Class<? extends T>> scanPackage(String packageName, Filter<Class<?>> filter, ClassLoader classLoader) {
        return new ClassScanner(packageName, filter, StandardCharsets.UTF_8, classLoader).scan();
    }

    static class ClassScanner<T> {
        private final String packageDirName;
        private final String packagePath;
        private final Filter<Class<?>> classFilter;
        private final Charset charset;
        private final ClassLoader classLoader;
        private final Set<Class<? extends T>> classes = new HashSet<Class<? extends T>>();

        public ClassScanner(String packageName, Filter<Class<?>> classFilter, Charset charset, ClassLoader classLoader) {
            this.packageDirName = packageName.replace(".", File.separator);
            this.packagePath = packageName.replace(".", "/");
            this.classFilter = classFilter;
            this.charset = charset;
            this.classLoader = classLoader;
        }

        public Set<Class<? extends T>> scan() {
            Enumeration<URL> resources = null;
            try {
                resources = this.classLoader.getResources(this.packagePath);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if ("file".equals(url.getProtocol())) {
                        this.scanFile(new File(URLDecoder.decode(url.getFile(), this.charset.name())), null);
                    }
                    if (!"jar".equals(url.getProtocol())) continue;
                    this.scanJar(ClassScanner.getJarFile(url));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.classes;
        }

        private void scanJar(JarFile jar) throws IOException {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                String string = name = entry.getName().startsWith("/") ? entry.getName().replaceFirst("/", "") : entry.getName();
                if (!StringUtils.isEmpty((CharSequence)this.packagePath) && !name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(0, name.length() - ".class".length()).replace("/", ".");
                this.addIfAccept(className);
            }
        }

        private static JarFile getJarFile(URL url) {
            try {
                JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
                return urlConnection.getJarFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void scanFile(File file, String rootDir) {
            File[] files;
            if (file.isFile()) {
                String fileName = file.getAbsolutePath();
                if (fileName.endsWith(".class")) {
                    String className = fileName.substring(rootDir == null ? 0 : rootDir.length(), fileName.length() - ".class".length()).replace(File.separatorChar, '.');
                    this.addIfAccept(className);
                } else if (fileName.endsWith(".jar")) {
                    try (JarFile jar = new JarFile(file);){
                        this.scanJar(jar);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (file.isDirectory() && null != (files = file.listFiles())) {
                for (File subFile : files) {
                    this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
                }
            }
        }

        private String subPathBeforePackage(File file) {
            String filePath = file.getAbsolutePath();
            if (StringUtils.isNotEmpty((CharSequence)this.packageDirName)) {
                filePath = StringUtils.substringBeforeLast((String)filePath, (String)this.packageDirName);
            }
            if (!filePath.endsWith(File.separator)) {
                return filePath + File.separator;
            }
            return filePath;
        }

        private void addIfAccept(String className) {
            try {
                Class<?> clazz = Class.forName(className);
                if (this.classFilter.accept(clazz)) {
                    this.classes.add(clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

