/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.Point;

public final class RangeModel
implements Serializable {
    private static final long serialVersionUID = -189369771303724339L;
    private int x_start;
    private int x_end;
    private int y_start;
    private int y_end;
    private static final int ZeroCharValue = 48;

    private static int getColAxisIndex(String pos, int start, int end) {
        if (end - start <= 1) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u533a\u57df\u5750\u6807\u65e0\u6548\uff1a%s", (String)"RangeModel_1", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
        }
        if (!Character.isLetter(pos.charAt(start))) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u533a\u57df\u5750\u6807\u65e0\u6548\uff1a%s", (String)"RangeModel_1", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
        }
        if (!Character.isLetter(pos.charAt(start + 1))) {
            return start + 1;
        }
        for (int index = start + 2; index < end; ++index) {
            if (Character.isLetter(pos.charAt(index))) continue;
            return index;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u533a\u57df\u5750\u6807\u65e0\u6548\uff1a%s", (String)"RangeModel_1", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
    }

    private static int pos2X(String pos, int start, int colAxisIndex) {
        int count = -1;
        for (int i = start; i < colAxisIndex; ++i) {
            char c = pos.charAt(i);
            count = c >= 'a' && c <= 'z' ? (int)((double)count + (double)(c - 96) * Math.pow(26.0, colAxisIndex - 1 - i)) : (int)((double)count + (double)(c - 64) * Math.pow(26.0, colAxisIndex - 1 - i));
        }
        return count;
    }

    private static int pos2Y(String pos, int colAxisIndex, int end) {
        int result = 0;
        int j = 1;
        for (int i = end - 1; i >= colAxisIndex; --i) {
            char c = pos.charAt(i);
            if (c >= '0' && c <= '9') {
                result += (c - 48) * j;
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"RangeModel_2", (String)"epm-epbs-common", (Object[])new Object[0]), pos));
            }
            j *= 10;
        }
        return result - 1;
    }

    public RangeModel(String area) {
        Objects.requireNonNull(area);
        int colonIndex = area.indexOf(58);
        if (colonIndex < 0) {
            int colAxisIndex = RangeModel.getColAxisIndex(area, 0, area.length());
            this.x_start = this.x_end = RangeModel.pos2X(area, 0, colAxisIndex);
            this.y_start = this.y_end = RangeModel.pos2Y(area, colAxisIndex, area.length());
        } else if (colonIndex > 0) {
            int colAxisIndex = RangeModel.getColAxisIndex(area, 0, colonIndex);
            this.x_start = RangeModel.pos2X(area, 0, colAxisIndex);
            this.y_start = RangeModel.pos2Y(area, colAxisIndex, colonIndex);
            colAxisIndex = RangeModel.getColAxisIndex(area, colonIndex + 1, area.length());
            this.x_end = RangeModel.pos2X(area, colonIndex + 1, colAxisIndex);
            this.y_end = RangeModel.pos2Y(area, colAxisIndex, area.length());
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u533a\u57df\u5750\u6807\u65e0\u6548\uff1a%s", (String)"RangeModel_1", (String)"epm-epbs-common", (Object[])new Object[0]), area));
        }
    }

    public RangeModel(int x_start, int x_end, int y_start, int y_end) {
        this.x_start = x_start;
        this.x_end = x_end;
        this.y_start = y_start;
        this.y_end = y_end;
    }

    public Integer getRowSize() {
        int startRowIndex = this.getY_start();
        int endRowIndex = this.getY_end();
        return endRowIndex - startRowIndex + 1;
    }

    public Integer getColSize() {
        int startColIndex = this.getX_start();
        int endColIndex = this.getX_end();
        return endColIndex - startColIndex + 1;
    }

    public boolean checkIsInArea(RangeModel range) {
        return this.x_start >= range.x_start && this.y_start >= range.y_start && this.x_end <= range.x_end && this.y_end <= range.y_end;
    }

    public boolean checkIsInArea(ICell range) {
        return this.x_start <= range.getCol() && this.y_start <= range.getRow() && this.x_end >= range.getCol() && this.y_end >= range.getRow();
    }

    public boolean checkIsInArea(int row, int col) {
        return this.x_start <= col && this.y_start <= row && this.x_end >= col && this.y_end >= row;
    }

    public boolean isRowInArea(int idx) {
        return this.y_start <= idx && this.y_end >= idx;
    }

    public boolean isColInArea(int idx) {
        return this.x_start <= idx && this.x_end >= idx;
    }

    public String getLeft_UpOne(int rowOffset, int colOffset) {
        if (this.x_start == this.x_end && this.y_start == this.y_end) {
            return ExcelUtils.xy2Pos(this.x_start - rowOffset, this.y_start - colOffset);
        }
        return ExcelUtils.xy2Pos(this.x_start - rowOffset, this.y_start - colOffset) + ":" + ExcelUtils.xy2Pos(this.x_end - rowOffset, this.y_end - colOffset);
    }

    public Set<String> getCombination() {
        HashSet<String> set = new HashSet<String>();
        for (int i = this.x_start; i <= this.x_end; ++i) {
            for (int j = this.y_start; j <= this.y_end; ++j) {
                set.add(i + "_" + j);
            }
        }
        return set;
    }

    public Collection<String> spiltToRow() {
        return this.spiltToRow(false);
    }

    public Collection<String> spiltToRow(boolean withTitle) {
        ArrayList<String> collection = new ArrayList<String>(this.y_end - this.y_start + 1);
        String title = ResManager.loadKDString((String)"\u884c", (String)"RangeModel_3", (String)"epm-epbs-common", (Object[])new Object[0]);
        for (int i = this.y_start; i <= this.y_end; ++i) {
            collection.add(i + 1 + (withTitle ? title : ""));
        }
        return collection;
    }

    public Collection<String> spiltToCol() {
        return this.spiltToCol(false);
    }

    public Collection<String> spiltToCol(boolean withTitle) {
        ArrayList<String> collection = new ArrayList<String>(this.y_end - this.y_start + 1);
        String title = ResManager.loadKDString((String)"\u5217", (String)"RangeModel_4", (String)"epm-epbs-common", (Object[])new Object[0]);
        for (int i = this.x_start; i <= this.x_end; ++i) {
            collection.add(ExcelUtils.int2pos(i) + (withTitle ? title : ""));
        }
        return collection;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x_start;
        result = 31 * result + this.x_end;
        result = 31 * result + this.y_start;
        result = 31 * result + this.y_end;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangeModel) {
            RangeModel other = (RangeModel)obj;
            return other.x_start == this.x_start && other.x_end == this.x_end && other.y_start == this.y_start && other.y_end == this.y_end;
        }
        return false;
    }

    public String toString() {
        String b;
        String a = ExcelUtils.xy2Pos(this.x_start, this.y_start);
        if (a.equals(b = ExcelUtils.xy2Pos(this.x_end, this.y_end))) {
            return a;
        }
        return ExcelUtils.xy2Pos(this.x_start, this.y_start) + ":" + ExcelUtils.xy2Pos(this.x_end, this.y_end);
    }

    public String getAreaRangeStr() {
        return ExcelUtils.xy2Pos(this.x_start, this.y_start) + ":" + ExcelUtils.xy2Pos(this.x_end, this.y_end);
    }

    public int getX_start() {
        return this.x_start;
    }

    public int getX_end() {
        return this.x_end;
    }

    public int getY_start() {
        return this.y_start;
    }

    public int getY_end() {
        return this.y_end;
    }

    public void setX_start(int x_start) {
        this.x_start = x_start;
    }

    public void setX_end(int x_end) {
        this.x_end = x_end;
    }

    public void setY_start(int y_start) {
        this.y_start = y_start;
    }

    public void setY_end(int y_end) {
        this.y_end = y_end;
    }

    public Point getStartPoint() {
        return new Point(this.getX_start(), this.getY_start());
    }

    public Point getEndPoint() {
        return new Point(this.getX_end(), this.getY_end());
    }

    public List<Integer> getAllRowOrCols(boolean isRow) {
        int end;
        int start;
        ArrayList<Integer> datas = new ArrayList<Integer>(16);
        if (isRow) {
            start = this.getY_start();
            end = this.getY_end();
        } else {
            start = this.getX_start();
            end = this.getX_end();
        }
        for (int i = start; i <= end; ++i) {
            datas.add(i);
        }
        return datas;
    }
}

