/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ScheduleUtil {
    public static final String FORM_SCH_SCHEDULE = "sch_schedule";
    public static final String FORM_SCH_JOB = "sch_job";
    public static final String FORM_SCH_TASKDEFINE = "sch_taskdefine";

    public static String createSchedule(ScheduleModel scheduleModel) {
        String jobId = ScheduleUtil.saveJobInfo(scheduleModel);
        scheduleModel.setJobId(jobId);
        PlanCreateEntry createEntry = new PlanCreateEntry();
        createEntry.setJobId(jobId);
        createEntry.setPlanNumber(scheduleModel.getScheduleNumber());
        createEntry.setPlanName(scheduleModel.getScheduleName());
        createEntry.setStartTime(Calendar.getInstance());
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(scheduleModel.getExpireTime());
        createEntry.setEndTime(endTime);
        createEntry.setRepeatModeEnum(RepeatModeEnum.NONE);
        createEntry.setPeriod(1);
        createEntry.setCornExpression(ScheduleUtil.dateToCron(scheduleModel.getPlanTime()));
        return ScheduleUtil.createPlan(createEntry);
    }

    public static String createJob(JobCreateEntry jobCreateEntry) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(jobCreateEntry.getAppId());
        jobInfo.setJobType(jobCreateEntry.getJobType());
        jobInfo.setName(jobCreateEntry.getJobName());
        jobInfo.setNumber(jobCreateEntry.getJobNumber());
        String id = Uuid16.create().toString();
        jobInfo.setId(id);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setTaskClassname(jobCreateEntry.getTaskClassName());
        jobInfo.setTaskDefineId(jobCreateEntry.getTaskDefineId());
        jobInfo.setParams(jobCreateEntry.getCustomParams());
        jobInfo.setCanStop(Boolean.valueOf(true));
        JobDispatcherProxy jobDispatcherProxy = new JobDispatcherProxy();
        String jobId = jobDispatcherProxy.createJob(jobInfo);
        return jobId;
    }

    public static String createPlan(PlanCreateEntry planCreateEntry) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(planCreateEntry.getJobId());
        planInfo.setName(planCreateEntry.getPlanName());
        planInfo.setNumber(planCreateEntry.getPlanNumber());
        planInfo.setStartTime(planCreateEntry.getStartTime());
        planInfo.setEndTime(planCreateEntry.getEndTime());
        planInfo.setRepeatMode(planCreateEntry.getRepeatModeEnum());
        planInfo.setPeriod(planCreateEntry.getPeriod());
        planInfo.setCronExpression(planCreateEntry.getCornExpression());
        JobDispatcherProxy jobDispatcherProxy = new JobDispatcherProxy();
        String planId = jobDispatcherProxy.createPlan(planInfo);
        return planId;
    }

    public static String numberFormat(String number, boolean isSchedule) {
        if (isSchedule) {
            return String.format("%s_SKDP_S", number);
        }
        return String.format("%s_SKDJ_S", number);
    }

    private static String saveJobInfo(ScheduleModel scheduleModel) {
        String classname = scheduleModel.getClassName();
        String taskDefineId = ScheduleUtil.getTaskDefineId(classname);
        String number = scheduleModel.getJobNumber();
        JobCreateEntry jobInfo = new JobCreateEntry();
        jobInfo.setAppId(scheduleModel.getAppId());
        jobInfo.setJobName(scheduleModel.getJobName());
        jobInfo.setJobNumber(StringUtils.isNotBlank((CharSequence)number) ? number : "JOB" + new SecureRandom().nextDouble() * 10000.0);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassName(classname);
        jobInfo.setTaskDefineId(taskDefineId);
        jobInfo.setCustomParams(scheduleModel.getParamMap());
        return ScheduleUtil.createJob(jobInfo);
    }

    public static void setJobParams(DynamicObject jobInfo, Map<String, Object> paramMap) {
        if (null == paramMap || paramMap.isEmpty()) {
            return;
        }
        jobInfo.set("params", (Object)JSONUtils.toString(paramMap));
        DynamicObjectCollection entrys = jobInfo.getDynamicObjectCollection("entryentity");
        entrys.clear();
        int seq = 0;
        for (Map.Entry<String, Object> param : paramMap.entrySet()) {
            DynamicObject row = (DynamicObject)entrys.getDynamicObjectType().createInstance();
            row.set("paramname", (Object)param.getKey());
            row.set("paramvalue", (Object)param.getValue().toString());
            row.set("paramtype", (Object)"0");
            row.set("seq", (Object)seq++);
            entrys.add((Object)row);
        }
    }

    public static String dateToCron(Date cronDate) {
        String cronPattern = "%s %s %s %s %s ?";
        Calendar cronCal = Calendar.getInstance();
        cronCal.setTime(cronDate);
        String cron = String.format(cronPattern, cronCal.get(13), cronCal.get(12), cronCal.get(11), cronCal.get(5), cronCal.get(2) + 1);
        return cron;
    }

    public static void deleteSchedule(Collection<String> scheduleIds) {
        if (CollectionUtils.isEmpty(scheduleIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", scheduleIds);
        DynamicObjectCollection scheduleList = QueryServiceHelper.query((String)FORM_SCH_SCHEDULE, (String)"id,job.id", (QFilter[])filter.toArray());
        Set<String> jobIds = scheduleList.stream().map(e -> e.getString("job.id")).collect(Collectors.toSet());
        JobDispatcherProxy jobDispatcherProxy = new JobDispatcherProxy();
        scheduleIds.forEach(e -> jobDispatcherProxy.deletePlan(e));
        jobIds.forEach(e -> jobDispatcherProxy.deleteJob(e));
    }

    public static String getTaskDefineId(String className) {
        QFilter filter = new QFilter("classname", "=", (Object)className);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)FORM_SCH_TASKDEFINE, (String)"id,number", (QFilter[])filter.toArray());
        return null != dyn ? dyn.getString("id") : null;
    }

    public static DynamicObject getScheduleDyn(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        return BusinessDataServiceHelper.loadSingle((String)FORM_SCH_SCHEDULE, (String)"id,number,job", (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection queryJobParams(String jobId) {
        DynamicObject jobDyn = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)FORM_SCH_JOB);
        return jobDyn.getDynamicObjectCollection("entryentity");
    }

    public static void updateJobParams(String jobId, Map<String, Object> paramMap) {
        DynamicObject jobDyn = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)FORM_SCH_JOB);
        ScheduleUtil.setJobParams(jobDyn, paramMap);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jobDyn});
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.afterUpdateJob(jobId);
    }

    public static void addSchedule(String scheduleId) {
        if (StringUtils.isEmpty((CharSequence)scheduleId)) {
            return;
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.afterAddSchedule(scheduleId);
    }

    public static String createTaskDefine(String number, String className, String appId) {
        String taskdefineId = ScheduleUtil.getTaskDefineId(className);
        if (StringUtils.isEmpty((CharSequence)taskdefineId)) {
            taskdefineId = Uuid16.create().toString();
            DynamicObject taskDefine = ORM.create().newDynamicObject(FORM_SCH_TASKDEFINE);
            taskDefine.set("id", (Object)taskdefineId);
            taskDefine.set("number", (Object)number);
            taskDefine.set("name", (Object)number);
            taskDefine.set("classname", (Object)className);
            taskDefine.set("appid", (Object)appId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDefine});
        }
        return taskdefineId;
    }

    public static void enableSchedule(String scheduleId, boolean enable) {
        String status = "status";
        String enableStatus = Boolean.TRUE.equals(enable) ? "1" : "0";
        DynamicObject scheduleDyn = BusinessDataServiceHelper.loadSingle((Object)scheduleId, (String)FORM_SCH_SCHEDULE, (String)"id,status,job");
        String jobId = scheduleDyn.getString("job.id");
        scheduleDyn.set("status", (Object)enableStatus);
        scheduleDyn.getDynamicObject("job").set("status", (Object)enableStatus);
        SaveServiceHelper.update((DynamicObject)scheduleDyn);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        if (enable) {
            scheduleManager.enableSchedule(scheduleId);
            scheduleManager.enableJob(jobId);
        } else {
            scheduleManager.disableSchedule(scheduleId);
            scheduleManager.disableJob(jobId);
        }
    }

    public static class PlanCreateEntry
    implements Serializable {
        private static final long serialVersionUID = -6171639303741496691L;
        private String jobId;
        private String planName;
        private String planNumber;
        private Calendar startTime;
        private Calendar endTime;
        private RepeatModeEnum repeatModeEnum;
        private String cornExpression;
        private int period;

        public PlanCreateEntry() {
        }

        public PlanCreateEntry(String jobId, String planName, String planNumber, Calendar startTime, Calendar endTime, RepeatModeEnum repeatModeEnum, String cornExpression, int period) {
            this.jobId = jobId;
            this.planName = planName;
            this.planNumber = planNumber;
            this.startTime = startTime;
            this.endTime = endTime;
            this.repeatModeEnum = repeatModeEnum;
            this.cornExpression = cornExpression;
            this.period = period;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getPlanName() {
            return this.planName;
        }

        public void setPlanName(String planName) {
            this.planName = planName;
        }

        public String getPlanNumber() {
            return this.planNumber;
        }

        public void setPlanNumber(String planNumber) {
            this.planNumber = planNumber;
        }

        public Calendar getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Calendar startTime) {
            this.startTime = startTime;
        }

        public Calendar getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Calendar endTime) {
            this.endTime = endTime;
        }

        public RepeatModeEnum getRepeatModeEnum() {
            return this.repeatModeEnum;
        }

        public void setRepeatModeEnum(RepeatModeEnum repeatModeEnum) {
            this.repeatModeEnum = repeatModeEnum;
        }

        public String getCornExpression() {
            return this.cornExpression;
        }

        public void setCornExpression(String cornExpression) {
            this.cornExpression = cornExpression;
        }

        public int getPeriod() {
            return this.period;
        }

        public void setPeriod(int period) {
            this.period = period;
        }

        public String toString() {
            return "PlanCreateEntry{jobId='" + this.jobId + '\'' + ", planName='" + this.planName + '\'' + ", planNumber='" + this.planNumber + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", repeatModeEnum=" + this.repeatModeEnum + ", cornExpression='" + this.cornExpression + '\'' + ", period=" + this.period + '}';
        }
    }

    public static class JobCreateEntry
    implements Serializable {
        private static final long serialVersionUID = -3203651957239884839L;
        private String jobName;
        private String jobNumber;
        private String appId;
        private JobType jobType;
        private String taskClassName;
        private String taskDefineId;
        private Map<String, Object> customParams;

        public JobCreateEntry() {
        }

        public JobCreateEntry(String jobName, String jobNumber, String appId, JobType jobType, String taskClassName, Map<String, Object> customParams) {
            this.jobName = jobName;
            this.jobNumber = jobNumber;
            this.appId = appId;
            this.jobType = jobType;
            this.taskClassName = taskClassName;
            this.customParams = customParams;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public String getJobNumber() {
            return this.jobNumber;
        }

        public void setJobNumber(String jobNumber) {
            this.jobNumber = jobNumber;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public JobType getJobType() {
            return this.jobType;
        }

        public void setJobType(JobType jobType) {
            this.jobType = jobType;
        }

        public String getTaskClassName() {
            return this.taskClassName;
        }

        public void setTaskClassName(String taskClassName) {
            this.taskClassName = taskClassName;
        }

        public Map<String, Object> getCustomParams() {
            return this.customParams;
        }

        public void setCustomParams(Map<String, Object> customParams) {
            this.customParams = customParams;
        }

        public String toString() {
            return "JobCreateEntry{jobName='" + this.jobName + '\'' + ", jobNumber='" + this.jobNumber + '\'' + ", appId='" + this.appId + '\'' + ", jobType=" + this.jobType + ", taskClassName='" + this.taskClassName + '\'' + ", customParams=" + this.customParams + '}';
        }

        public String getTaskDefineId() {
            return this.taskDefineId;
        }

        public void setTaskDefineId(String taskDefineId) {
            this.taskDefineId = taskDefineId;
        }
    }

    public static class ScheduleModel {
        private String scheduleNumber;
        private String scheduleName;
        private String jobNumber;
        private String jobName;
        private Map<String, Object> paramMap;
        private Date expireTime;
        private Date planTime;
        private String className;
        private String txthost;
        private String jobId;
        private String appId;

        public String getScheduleNumber() {
            return this.scheduleNumber;
        }

        public void setScheduleNumber(String scheduleNumber) {
            this.scheduleNumber = scheduleNumber;
        }

        public String getScheduleName() {
            return this.scheduleName;
        }

        public void setScheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
        }

        public String getJobNumber() {
            return this.jobNumber;
        }

        public void setJobNumber(String jobNumber) {
            this.jobNumber = jobNumber;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public Map<String, Object> getParamMap() {
            return this.paramMap;
        }

        public void setParamMap(Map<String, Object> paramMap) {
            this.paramMap = paramMap;
        }

        public Date getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(Date expireTime) {
            this.expireTime = expireTime;
        }

        public Date getPlanTime() {
            return this.planTime;
        }

        public void setPlanTime(Date planTime) {
            this.planTime = planTime;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getTxthost() {
            return this.txthost;
        }

        public void setTxthost(String txthost) {
            this.txthost = txthost;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }
    }
}

