/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.HashMap;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.util.StringUtils;

public class SyncCacheUtil {
    public static final String APP_TIME_NAME = "_epbsCT.";
    public static final String TIMEKEY = "#time#";

    private static IAppCache getAppTimeCache() {
        return AppCache.get((String)APP_TIME_NAME);
    }

    public static long getTimeFromAppCache(String key) {
        String timekey = key + TIMEKEY;
        String time = (String)SyncCacheUtil.getAppTimeCache().get(timekey, String.class);
        if (StringUtils.isNotEmpty((String)time)) {
            return Long.parseLong(time);
        }
        return 0L;
    }

    public static void updateAppCacheTime(String key) {
        String timekey = key + TIMEKEY;
        SyncCacheUtil.getAppTimeCache().put(timekey, (Object)System.currentTimeMillis());
    }

    public static long getTimeFromLocalCache(LocalMemoryCache cache, String key) {
        if (!cache.contains(TIMEKEY)) {
            return 0L;
        }
        HashMap timemap = (HashMap)cache.get(TIMEKEY);
        return timemap.getOrDefault(key, 0L);
    }

    public static void updateLocalCacheTime(LocalMemoryCache cache, String key) {
        HashMap value = cache.get(TIMEKEY);
        if (value == null) {
            value = new HashMap();
            cache.put(TIMEKEY, value);
        }
        ((HashMap)value).put(key, System.currentTimeMillis());
    }

    public static long getOrCreateAppCacheTime(String key) {
        String timekey = key + TIMEKEY;
        long time = System.currentTimeMillis();
        SyncCacheUtil.getAppTimeCache().put(timekey, (Object)time);
        return time;
    }
}

