/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

public class TXUtils {
    public static void required(Consumer<TXHandle> consumer) {
        try (TXHandle txHandle = TX.required();){
            try {
                consumer.accept(txHandle);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    public static void requiresNew(Consumer<TXHandle> consumer) {
        try (TXHandle txHandle = TX.requiresNew((String)"noname");){
            try {
                consumer.accept(txHandle);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    public static void requiresNew(String key, Consumer<TXHandle> consumer) {
        try (TXHandle txHandle = TX.requiresNew((String)key);){
            try {
                consumer.accept(txHandle);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    public static <R> R requiresNewFunc(Function<TXHandle, R> consumer) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew((String)"noname");){
            R r = consumer.apply(txHandle);
            return r;
        }
        catch (Exception e) {
            try {
                txHandle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

