/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epdm.common.constant.EPDMConstant;
import kd.epm.epdm.common.database.IDataSource;
import kd.epm.epdm.common.enums.DBTypeEnum;

public abstract class AbsDataSource
implements IDataSource {
    private static final Log log = LogFactory.getLog(AbsDataSource.class);
    protected final DBTypeEnum type;
    protected String driverClassName;
    protected Connection conn;
    protected DataSource ods;
    protected DBRoute dbRoute;

    protected AbsDataSource(DBTypeEnum type) {
        this.type = type;
        switch (type) {
            case POSTGRESQL: 
            case POSTGRESQL_NEW: 
            case SELF: {
                this.driverClassName = "org.postgresql.Driver";
                break;
            }
            case MYSQL: {
                this.driverClassName = "com.mysql.cj.jdbc.Driver";
                break;
            }
            case ORACLE: {
                this.driverClassName = "oracle.jdbc.OracleDriver";
                break;
            }
            case SQLSERVER: {
                this.driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
        }
    }

    @Override
    public DBRoute dbRoute() {
        return this.dbRoute;
    }

    @Override
    public DataSource createDataSource(DynamicObject cfg) throws SQLException {
        String url = this.getURL(cfg);
        String user = cfg.getString("user");
        String password = cfg.getString("newpwd");
        DruidDataSource ods = new DruidDataSource();
        ods.setDriverClassName(this.driverClassName);
        ods.setUrl(url);
        ods.setUsername(user);
        ods.setPassword(password);
        ods.setInitialSize(5);
        ods.setMinIdle(5);
        ods.setMaxActive(20);
        ods.setMaxWait(60000L);
        ods.setPoolPreparedStatements(true);
        this.ods = ods;
        return ods;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (null != this.conn && !this.conn.isClosed()) {
            return this.conn;
        }
        if (null == this.ods) {
            return null;
        }
        this.conn = this.ods.getConnection();
        return this.conn;
    }

    public boolean testConnection() throws SQLException {
        switch (this.type) {
            case POSTGRESQL: 
            case POSTGRESQL_NEW: 
            case MYSQL: 
            case ORACLE: 
            case SQLSERVER: {
                return this.testDbConnection();
            }
        }
        return this.testSelfConnection();
    }

    public boolean testSelfConnection() {
        AtomicBoolean checkConnection = new AtomicBoolean(false);
        try {
            TXUtils.requiresNew(tx -> checkConnection.set((Boolean)DB.query((DBRoute)EPDMConstant.DB_ROUTE, (String)this.getTestSQL(false), ResultSet::next)));
        }
        catch (Exception e) {
            return (Boolean)DB.query((DBRoute)EPDMConstant.DB_ROUTE, (String)this.getTestSQL(true), ResultSet::next);
        }
        return checkConnection.get();
    }

    public void setDbRoute(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    @Override
    public boolean tableExists(String table, String schema) throws SQLException {
        ResultSet rs = null;
        boolean flag = false;
        if (null == this.getConnection()) {
            return flag;
        }
        try {
            int pos;
            DatabaseMetaData metaData = this.conn.getMetaData();
            rs = metaData.getTables(null, schema, table, new String[]{"TABLE"});
            flag = rs.next();
            if (!flag && (pos = table.indexOf(".")) > 0 && !(flag = (rs = metaData.getTables(null, schema, table.substring((pos = table.lastIndexOf(".")) + 1), new String[]{"TABLE"})).next())) {
                rs = metaData.getTables(null, table.substring(0, pos), table.substring(pos + 1), new String[]{"TABLE"});
                flag = rs.next();
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException se) {
                log.error(se.getMessage());
            }
        }
        return flag;
    }

    protected boolean testDbConnection() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        boolean flag = false;
        if (null == this.getConnection()) {
            return flag;
        }
        try {
            stmt = this.conn.createStatement();
            try {
                rs = stmt.executeQuery(this.getTestSQL(false));
                flag = rs.next();
            }
            catch (Exception e) {
                rs = stmt.executeQuery(this.getTestSQL(true));
                flag = rs.next();
            }
            rs.close();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException se) {
                log.error(se.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {
                log.error(se.getMessage());
            }
        }
        return flag;
    }

    @Override
    public DBTypeEnum getType() {
        return this.type;
    }
}

