/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.CUDWrapper;
import kd.epm.epdm.common.database.DbQueryUtils;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;

public class CUDPgSQL
extends CUDWrapper {
    private static final Log log = LogFactory.getLog(CUDPgSQL.class);

    @Override
    public int create(AbsDataSource ods, String table, DynamicObjectCollection fields, List<Map<String, Object>> rows) {
        Connection conn;
        PreparedStatement stmtOut;
        block10: {
            int n;
            String insertSql = "INSERT INTO " + table;
            StringBuilder cols = new StringBuilder();
            Map<String, Object> r = rows.get(0);
            int size = 0;
            for (DynamicObject dy : fields) {
                String field = dy.getString("field");
                if (!r.containsKey(field)) continue;
                if (cols.length() < 1) {
                    cols.append(field);
                } else {
                    cols.append(",").append(field);
                }
                ++size;
            }
            insertSql = insertSql + "(" + cols + ") VALUES (" + this.buildValueSql(size) + ")";
            stmtOut = null;
            conn = null;
            try {
                conn = ods.getConnection();
                if (null == conn) break block10;
                conn.setAutoCommit(false);
                stmtOut = conn.prepareStatement(insertSql);
                for (Map<String, Object> row : rows) {
                    int parameterIndex = 1;
                    for (DynamicObject dy : fields) {
                        if (!row.containsKey(dy.getString("field"))) continue;
                        this.setValue(dy, parameterIndex, stmtOut, row);
                        ++parameterIndex;
                    }
                    stmtOut.addBatch();
                }
                int[] rs = stmtOut.executeBatch();
                conn.commit();
                stmtOut.clearBatch();
                if (null == rs) break block10;
                int count = 0;
                for (Object c : (Object)rs) {
                    count += c;
                }
                n = count;
            }
            catch (Exception e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDPgSQL_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), insertSql));
                }
                catch (Throwable throwable) {
                    DbQueryUtils.close(stmtOut, conn);
                    throw throwable;
                }
            }
            DbQueryUtils.close(stmtOut, conn);
            return n;
        }
        DbQueryUtils.close(stmtOut, conn);
        return 0;
    }

    @Override
    public int update(AbsDataSource ods, String table, DynamicObjectCollection fields, Map<String, Object> row, String where) {
        Connection conn;
        PreparedStatement stmtOut;
        block11: {
            int n;
            String sql = "UPDATE " + table + " SET ";
            StringBuilder setString = new StringBuilder();
            ArrayList<DynamicObject> columns = new ArrayList<DynamicObject>(fields.size());
            for (DynamicObject dy : fields) {
                String field = EpdmDmPresetEnum.field.getString(dy);
                if (!row.containsKey(field)) continue;
                String value = null;
                if (row.get(field) instanceof String) {
                    value = (String)row.get(field);
                }
                if (null != value && value.length() > 2 && value.startsWith("`") && value.endsWith("`")) {
                    value = value.substring(1, value.length() - 1);
                    if (setString.length() < 1) {
                        setString.append(field).append("=").append(value);
                        continue;
                    }
                    setString.append(",").append(field).append("=").append(value);
                    continue;
                }
                if (setString.length() < 1) {
                    setString.append(field).append("=?");
                } else {
                    setString.append(",").append(field).append("=?");
                }
                columns.add(dy);
            }
            sql = sql + setString + " " + where;
            this.validitySelectSql(sql, "U");
            stmtOut = null;
            conn = null;
            try {
                conn = ods.getConnection();
                if (null == conn) break block11;
                int count = this.count(conn, table, where);
                stmtOut = conn.prepareStatement(sql);
                int parameterIndex = 1;
                for (DynamicObject dy : columns) {
                    this.setValue(dy, parameterIndex, stmtOut, row);
                    ++parameterIndex;
                }
                stmtOut.addBatch();
                stmtOut.execute();
                n = count;
            }
            catch (Exception e) {
                try {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDPgSQL_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), sql));
                }
                catch (Throwable throwable) {
                    DbQueryUtils.close(stmtOut, conn);
                    throw throwable;
                }
            }
            DbQueryUtils.close(stmtOut, conn);
            return n;
        }
        DbQueryUtils.close(stmtOut, conn);
        return 0;
    }

    @Override
    public int delete(AbsDataSource ods, String table, String where) {
        Connection conn;
        Statement stmt;
        block4: {
            int n;
            String sql = "DELETE FROM " + table + " " + where;
            this.validitySelectSql(sql, "D");
            stmt = null;
            conn = null;
            try {
                conn = ods.getConnection();
                if (null == conn) break block4;
                int count = this.count(conn, table, where);
                stmt = conn.createStatement();
                stmt.execute(sql);
                n = count;
            }
            catch (Exception e) {
                try {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDPgSQL_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), sql));
                }
                catch (Throwable throwable) {
                    DbQueryUtils.close(stmt, conn);
                    throw throwable;
                }
            }
            DbQueryUtils.close(stmt, conn);
            return n;
        }
        DbQueryUtils.close(stmt, conn);
        return 0;
    }

    protected int count(Connection conn, String table, String where) {
        ResultSet rs;
        Statement stmt;
        block4: {
            int n;
            String select = "SELECT count(1) FROM " + table + " " + where;
            stmt = null;
            rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(select);
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDPgSQL_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), select));
                }
                catch (Throwable throwable) {
                    DbQueryUtils.close(rs, stmt);
                    throw throwable;
                }
            }
            DbQueryUtils.close(rs, stmt);
            return n;
        }
        DbQueryUtils.close(rs, stmt);
        return 0;
    }
}

