/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.CUDWrapper;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;

public class CUDSelf
extends CUDWrapper {
    /*
     * WARNING - void declaration
     */
    @Override
    public int create(AbsDataSource ods, String table, DynamicObjectCollection fields, List<Map<String, Object>> rows) {
        String insertSql = "INSERT INTO " + table;
        StringBuilder cols = new StringBuilder();
        ArrayList<String> columns = new ArrayList<String>(fields.size());
        Map<String, Object> r = rows.get(0);
        int size = 0;
        for (Object dy : fields) {
            String field = EpdmDmPresetEnum.field.getString((DynamicObject)dy);
            if (!r.containsKey(field)) continue;
            if (cols.length() < 1) {
                cols.append(field);
            } else {
                cols.append(",").append(field);
            }
            columns.add(field);
            ++size;
        }
        insertSql = insertSql + "(" + cols + ") VALUES (" + this.buildValueSql(size) + ")";
        this.validitySelectSql(insertSql, "C");
        try {
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Map map : rows) {
                Object[] objects = new Object[size];
                for (int i = 0; i < size; ++i) {
                    objects[i] = map.get(columns.get(i));
                }
                params.add(objects);
            }
            int[] rs = DB.executeBatch((DBRoute)ods.dbRoute(), (String)insertSql, params);
            if (null != rs) {
                void var13_16;
                boolean bl = false;
                for (int c : rs) {
                    var13_16 += c;
                }
                return (int)var13_16;
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDSelf_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), insertSql));
        }
        return 0;
    }

    @Override
    public int update(AbsDataSource ods, String table, DynamicObjectCollection fields, Map<String, Object> row, String where) {
        String sql = "UPDATE " + table + " SET ";
        StringBuilder setString = new StringBuilder();
        ArrayList<String> columns = new ArrayList<String>(fields.size());
        int size = 0;
        for (DynamicObject dy : fields) {
            String field = EpdmDmPresetEnum.field.getString(dy);
            if (!row.containsKey(field)) continue;
            String value = null;
            if (row.get(field) instanceof String) {
                value = (String)row.get(field);
            }
            if (null != value && value.length() > 2 && value.startsWith("`") && value.endsWith("`")) {
                value = value.substring(1, value.length() - 1);
                if (setString.length() < 1) {
                    setString.append(field).append("=").append(value);
                    continue;
                }
                setString.append(",").append(field).append("=").append(value);
                continue;
            }
            if (setString.length() < 1) {
                setString.append(field).append("=?");
            } else {
                setString.append(",").append(field).append("=?");
            }
            columns.add(field);
            ++size;
        }
        sql = sql + setString + " " + where;
        this.validitySelectSql(sql, "U");
        try {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            Object[] objects = new Object[size];
            for (int i = 0; i < size; ++i) {
                objects[i] = row.get(columns.get(i));
            }
            params.add(objects);
            int[] rs = DB.executeBatch((DBRoute)ods.dbRoute(), (String)sql, params);
            if (null != rs) {
                int count = 0;
                for (int c : rs) {
                    count += c;
                }
                return count;
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDSelf_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), sql));
        }
        return 0;
    }

    @Override
    public int delete(AbsDataSource ods, String table, String where) {
        String sql = "DELETE FROM " + table + " " + where;
        this.validitySelectSql(sql, "D");
        try {
            int count = this.count(ods, table, where);
            if (DB.execute((DBRoute)ods.dbRoute(), (String)sql)) {
                return count;
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDSelf_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), sql));
        }
        return 0;
    }

    protected int count(AbsDataSource ods, String table, String where) {
        String select = "SELECT count(1) FROM " + table + " " + where;
        return (Integer)DB.query((DBRoute)ods.dbRoute(), (String)select, rs -> {
            try {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        });
    }
}

