/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.CUDMySQL;
import kd.epm.epdm.common.database.CUDOracle;
import kd.epm.epdm.common.database.CUDPgSQL;
import kd.epm.epdm.common.database.CUDSelf;
import kd.epm.epdm.common.database.DbQueryUtils;
import kd.epm.epdm.common.enums.DBTypeEnum;
import kd.epm.epdm.common.enums.DataModelFieldDataTypeEnum;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;

public abstract class CUDWrapper {
    protected String regex = "^[a-zA-Z0-9_]+$";
    private static final Map<String, CUDWrapper> wrapperImpls = new HashMap<String, CUDWrapper>();
    protected final String[] keywords = new String[]{"DROP ", "GRANT ", "REVOKE ", "ALTER ", "TRUNCATE "};

    public abstract int create(AbsDataSource var1, String var2, DynamicObjectCollection var3, List<Map<String, Object>> var4);

    public abstract int update(AbsDataSource var1, String var2, DynamicObjectCollection var3, Map<String, Object> var4, String var5);

    public abstract int delete(AbsDataSource var1, String var2, String var3);

    public static CUDWrapper factory(AbsDataSource ods) {
        return wrapperImpls.get(ods.getType().name());
    }

    protected String buildValueSql(int size) {
        StringBuilder vals = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (vals.length() < 1) {
                vals.append("?");
                continue;
            }
            vals.append(",").append("?");
        }
        return vals.toString();
    }

    protected void setValue(DynamicObject dy, int parameterIndex, PreparedStatement stmtOut, Map<String, Object> row) throws SQLException {
        DataModelFieldDataTypeEnum type = DataModelFieldDataTypeEnum.getBy(EpdmDmPresetEnum.datatype.getString(dy));
        if (null == type) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u6570\u636e\u7c7b\u578b[%s]", (String)"CUDWrapper_1", (String)"epm-epbs-common", (Object[])new Object[0]), EpdmDmPresetEnum.datatype.getString(dy)));
        }
        String field = EpdmDmPresetEnum.field.getString(dy);
        switch (type) {
            case DATETIME: {
                stmtOut.setDate(parameterIndex, (Date)row.get(field));
                break;
            }
            case INTEGER: {
                stmtOut.setInt(parameterIndex, (Integer)row.get(field));
                break;
            }
            case LONG: {
                stmtOut.setLong(parameterIndex, (Long)row.get(field));
                break;
            }
            case DECIMAL: {
                stmtOut.setBigDecimal(parameterIndex, (BigDecimal)row.get(field));
                break;
            }
            default: {
                stmtOut.setString(parameterIndex, String.valueOf(row.get(field)));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void execute(AbsDataSource ods, String sql) {
        Statement stmt;
        Connection conn;
        block5: {
            if (ods.getType() == DBTypeEnum.SELF || ods.getType() == DBTypeEnum.CURRENTDB) {
                DB.execute((DBRoute)ods.dbRoute(), (String)sql);
                return;
            }
            conn = null;
            stmt = null;
            try {
                conn = ods.getConnection();
                if (null == conn) break block5;
                stmt = conn.createStatement();
                stmt.execute(sql);
            }
            catch (Exception e) {
                try {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"CUDWrapper_2", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), sql));
                }
                catch (Throwable throwable) {
                    DbQueryUtils.close(stmt, conn);
                    throw throwable;
                }
            }
        }
        DbQueryUtils.close(stmt, conn);
        return;
    }

    protected void validitySelectSql(String sql, String act) {
        String keyword;
        if (StringUtils.isEmpty((String)sql)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u662fSQL\u8bed\u53e5\u4e0d\u5408\u6cd5", (String)"CUDWrapper_3", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        String sqlUpperCase = sql.toUpperCase(Locale.ROOT);
        switch (act) {
            case "C": {
                if (sqlUpperCase.startsWith("INSERT")) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301INSERT", (String)"CUDWrapper_4", (String)"epm-epbs-common", (Object[])new Object[0]));
            }
            case "U": {
                if (!sqlUpperCase.startsWith("UPDATE")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301UPDATE", (String)"CUDWrapper_5", (String)"epm-epbs-common", (Object[])new Object[0]));
                }
                if (sqlUpperCase.contains(" WHERE ")) break;
                throw new KDBizException(ResManager.loadKDString((String)"UPDATE \u5fc5\u987b\u6307\u5b9a\u6761\u4ef6\u8303\u56f4", (String)"CUDWrapper_6", (String)"epm-epbs-common", (Object[])new Object[0]));
            }
            case "D": {
                if (!sqlUpperCase.startsWith("DELETE")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301DELETE", (String)"CUDWrapper_7", (String)"epm-epbs-common", (Object[])new Object[0]));
                }
                if (sqlUpperCase.contains(" WHERE ")) break;
                throw new KDBizException(ResManager.loadKDString((String)"DELETE \u5fc5\u987b\u6307\u5b9a\u6761\u4ef6\u8303\u56f4", (String)"CUDWrapper_8", (String)"epm-epbs-common", (Object[])new Object[0]));
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b[%s]", (String)"CUDWrapper_9", (String)"epm-epbs-common", (Object[])new Object[0]), act));
            }
        }
        if (null != (keyword = this.validitySQLKeywords(sqlUpperCase))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8bed\u53e5\u4e2d\u5305\u542b\u975e\u6cd5\u5173\u952e\u8bcd[%s]", (String)"CUDWrapper_10", (String)"epm-epbs-common", (Object[])new Object[0]), keyword));
        }
    }

    protected String validitySQLKeywords(String sql) {
        for (String keyword : this.keywords) {
            if (!sql.contains(keyword)) continue;
            return keyword;
        }
        return null;
    }

    static {
        wrapperImpls.put(DBTypeEnum.MYSQL.name(), new CUDMySQL());
        wrapperImpls.put(DBTypeEnum.CURRENTDB.name(), new CUDSelf());
        wrapperImpls.put(DBTypeEnum.SELF.name(), new CUDSelf());
        wrapperImpls.put(DBTypeEnum.ORACLE.name(), new CUDOracle());
        wrapperImpls.put(DBTypeEnum.POSTGRESQL.name(), new CUDPgSQL());
        wrapperImpls.put(DBTypeEnum.POSTGRESQL_NEW.name(), new CUDPgSQL());
    }
}

