/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.DDLWrapper;
import kd.epm.epdm.common.database.ModelUtils;
import kd.epm.epdm.common.enums.DataModelFieldDataTypeEnum;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;

public class DDLSelf
extends DDLWrapper {
    @Override
    public String createTable(AbsDataSource ods, String table, DynamicObjectCollection fields) {
        ModelUtils.validityTable(table);
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(table).append(" (");
        int idx = 0;
        for (DynamicObject dy : fields) {
            String value = EpdmDmPresetEnum.field.getString(dy);
            ModelUtils.validityField(value);
            if (idx > 0 && !sql.toString().endsWith(",")) {
                sql.append(",");
            }
            sql.append(value.toUpperCase(Locale.ROOT));
            boolean required = "Y".equalsIgnoreCase(EpdmDmPresetEnum.required.getString(dy));
            sql.append(this.getKqlFieldType(EpdmDmPresetEnum.datatype.getString(dy), required, EpdmDmPresetEnum.datalen.getInt(dy)));
            ++idx;
        }
        sql.append(")");
        this.executeCreate(ods, sql.toString());
        return sql.toString();
    }

    @Override
    public String createPk(AbsDataSource ods, String table, String field) {
        String pkName = table.startsWith("t_") || table.startsWith("T_") ? "PK_" + table.substring(2).toUpperCase(Locale.ROOT) : "PK_" + table.toUpperCase(Locale.ROOT);
        String sql = "EXEC P_ALTERPK '" + pkName + "', '" + table + "', '" + field + "', '1'";
        this.executeCreate(ods, sql);
        return sql;
    }

    @Override
    public String createIndex(AbsDataSource ods, String table, List<DynamicObject> fields, String name) {
        String pre = this.getTablePre(table);
        fields.sort(Comparator.comparingInt(EpdmDmPresetEnum.idxord::getInt));
        String idxName = pre + "_" + name.toUpperCase(Locale.ROOT);
        StringBuilder fieldBuilder = new StringBuilder();
        boolean unique = false;
        for (DynamicObject dy : fields) {
            if (EpdmDmPresetEnum.isunique.getBoolean(dy).booleanValue()) {
                unique = true;
            }
            if (fieldBuilder.length() < 1) {
                fieldBuilder.append(EpdmDmPresetEnum.field.getString(dy));
                continue;
            }
            fieldBuilder.append(",").append(EpdmDmPresetEnum.field.getString(dy));
        }
        String sql = unique ? "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = '" + table.toUpperCase(Locale.ROOT) + "' AND KSQL_INDNAME = '" + idxName + "') CREATE UNIQUE INDEX " + idxName + " ON " + table.toUpperCase(Locale.ROOT) + " ( " + fieldBuilder + " )" : "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = '" + table.toUpperCase(Locale.ROOT) + "' AND KSQL_INDNAME = '" + idxName + "') CREATE INDEX " + idxName + " ON " + table.toUpperCase(Locale.ROOT) + " ( " + fieldBuilder + " )";
        this.executeCreate(ods, sql);
        return sql;
    }

    @Override
    public String addField(AbsDataSource ods, String table, DynamicObject field) {
        String value = EpdmDmPresetEnum.field.getString(field);
        ModelUtils.validityField(value);
        boolean required = "Y".equalsIgnoreCase(EpdmDmPresetEnum.required.getString(field));
        String sql = "ALTER TABLE " + table.toUpperCase(Locale.ROOT) + " ADD (" + value.toUpperCase(Locale.ROOT) + " " + this.getKqlFieldType(EpdmDmPresetEnum.datatype.getString(field), required, EpdmDmPresetEnum.datalen.getInt(field)) + " )";
        this.executeCreate(ods, sql);
        return sql;
    }

    private String getKqlFieldType(String type, boolean required, int len) {
        DataModelFieldDataTypeEnum dataType = DataModelFieldDataTypeEnum.getBy(type);
        if (null == dataType) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u652f\u6301\u5b57\u6bb5\u7c7b\u578b\uff1a\u201c%1$s\u201d", (String)"DDLSelf_1", (String)"epm-epbs-common", (Object[])new Object[0]), type));
        }
        String typeString = "";
        switch (dataType) {
            case LONG: {
                typeString = " BIGINT DEFAULT 0 NOT NULL";
                break;
            }
            case TEXT: {
                typeString = " NCLOB NULL";
                break;
            }
            case BOOLEAN: {
                typeString = " CHAR(1) DEFAULT '0' NOT NULL";
                break;
            }
            case DECIMAL: {
                typeString = " DECIMAL(23,10) DEFAULT 0 NOT NULL";
                break;
            }
            case INTEGER: {
                typeString = " INT DEFAULT 0 NOT NULL";
                break;
            }
            case VARCHAR: {
                if (len < 1) {
                    len = 50;
                }
                typeString = " VARCHAR(" + len + ") DEFAULT ' ' NOT NULL";
                break;
            }
            case DATETIME: {
                typeString = " DATETIME";
            }
        }
        return typeString;
    }
}

