/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.DDLMySQL;
import kd.epm.epdm.common.database.DDLOracle;
import kd.epm.epdm.common.database.DDLPgSQL;
import kd.epm.epdm.common.database.DDLSelf;
import kd.epm.epdm.common.database.DDLSqlServer;
import kd.epm.epdm.common.database.DbQueryUtils;
import kd.epm.epdm.common.enums.DBTypeEnum;

public abstract class DDLWrapper {
    private static final Map<String, DDLWrapper> wrapperImpls = new HashMap<String, DDLWrapper>();

    public abstract String createTable(AbsDataSource var1, String var2, DynamicObjectCollection var3);

    public abstract String createPk(AbsDataSource var1, String var2, String var3);

    public abstract String createIndex(AbsDataSource var1, String var2, List<DynamicObject> var3, String var4);

    public abstract String addField(AbsDataSource var1, String var2, DynamicObject var3);

    public static DDLWrapper factory(AbsDataSource ods) {
        return wrapperImpls.get(ods.getType().name());
    }

    protected String getTablePre(String table) {
        String pre = table.startsWith("t_") || table.startsWith("T_") ? "IDX_" + table.substring(2).toUpperCase(Locale.ROOT) : "IDX_" + table.toUpperCase(Locale.ROOT);
        return pre;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeCreate(AbsDataSource ods, String sql) {
        Statement stmt;
        Connection conn;
        block5: {
            if (ods.getType() == DBTypeEnum.SELF || ods.getType() == DBTypeEnum.CURRENTDB) {
                DB.execute((DBRoute)ods.dbRoute(), (String)sql);
                return;
            }
            conn = null;
            stmt = null;
            try {
                conn = ods.getConnection();
                if (null == conn) break block5;
                stmt = conn.createStatement();
                stmt.execute(sql);
            }
            catch (Exception e) {
                try {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\uff1a%1$s\uff0cSQL\uff1a%2$s", (String)"DDLWrapper_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), sql));
                }
                catch (Throwable throwable) {
                    DbQueryUtils.close(stmt, conn);
                    throw throwable;
                }
            }
        }
        DbQueryUtils.close(stmt, conn);
        return;
    }

    public boolean tableExists(AbsDataSource ods, String table) {
        ResultSet rs;
        Object stmt;
        Connection conn;
        block6: {
            if (ods.getType() == DBTypeEnum.SELF || ods.getType() == DBTypeEnum.CURRENTDB) {
                return DB.exitsTable((DBRoute)ods.dbRoute(), (String)table);
            }
            conn = null;
            stmt = null;
            rs = null;
            conn = ods.getConnection();
            if (null == conn) break block6;
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getTables(null, null, table, null);
            boolean bl = rs.next();
            DbQueryUtils.close(rs, stmt, conn);
            return bl;
        }
        try {
            try {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u94fe\u63a5\u5931\u8d25\u3002", (String)"DDLWrapper_2", (String)"epm-epbs-common", (Object[])new Object[0]));
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25\uff1a%1$s\uff0cTable\uff1a%2$s", (String)"DDLWrapper_3", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), table));
            }
        }
        catch (Throwable throwable) {
            DbQueryUtils.close(rs, stmt, conn);
            throw throwable;
        }
    }

    static {
        wrapperImpls.put(DBTypeEnum.MYSQL.name(), new DDLMySQL());
        wrapperImpls.put(DBTypeEnum.CURRENTDB.name(), new DDLSelf());
        wrapperImpls.put(DBTypeEnum.SELF.name(), new DDLSelf());
        wrapperImpls.put(DBTypeEnum.ORACLE.name(), new DDLOracle());
        wrapperImpls.put(DBTypeEnum.SQLSERVER.name(), new DDLSqlServer());
        wrapperImpls.put(DBTypeEnum.POSTGRESQL.name(), new DDLPgSQL());
        wrapperImpls.put(DBTypeEnum.POSTGRESQL_NEW.name(), new DDLPgSQL());
    }
}

