/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.cache.ICache;
import kd.epm.epbs.common.cache.factory.CacheGenFactory;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.IDataSource;
import kd.epm.epdm.common.database.MySQLDataSource;
import kd.epm.epdm.common.database.OrcDataSource;
import kd.epm.epdm.common.database.PGDataSource;
import kd.epm.epdm.common.database.SelfDataSource;
import kd.epm.epdm.common.database.SqlServerDataSource;
import kd.epm.epdm.common.enums.DBTypeEnum;

public class DbQueryUtils {
    private static final ICache cache = CacheGenFactory.getTemporaryCache();
    private static final Log log = LogFactory.getLog(DbQueryUtils.class);
    private static final String[] keywords = new String[]{"UPDATE ", "DELETE ", "INSERT ", "DROP ", "GRANT ", "REVOKE ", "ALTER ", "TRUNCATE "};
    private static final String ORA_ROW_NUM = "FF_ORA_RM";

    public static void close(AutoCloseable ... sources) {
        if (null == sources) {
            return;
        }
        for (AutoCloseable src : sources) {
            if (null == src) continue;
            try {
                src.close();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public static AbsDataSource getDataSource(DynamicObject cfg, String dbRoute) {
        AbsDataSource dataSource;
        try {
            if (null != cfg) {
                DBTypeEnum type = DBTypeEnum.getBy(cfg.getString("database_type"));
                switch (type) {
                    case POSTGRESQL: 
                    case POSTGRESQL_NEW: {
                        dataSource = new PGDataSource(type);
                        break;
                    }
                    case MYSQL: {
                        dataSource = new MySQLDataSource(type);
                        break;
                    }
                    case ORACLE: {
                        dataSource = new OrcDataSource(type);
                        break;
                    }
                    case SQLSERVER: {
                        dataSource = new SqlServerDataSource(type);
                        break;
                    }
                    default: {
                        dataSource = new SelfDataSource(DBTypeEnum.SELF);
                        if (!StringUtils.isEmpty((String)dbRoute)) {
                            dataSource.setDbRoute(new DBRoute(dbRoute));
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                dataSource = new SelfDataSource(DBTypeEnum.SELF);
                if (!StringUtils.isEmpty((String)dbRoute)) {
                    dataSource.setDbRoute(new DBRoute(dbRoute));
                }
            }
            dataSource.createDataSource(cfg);
            if (!dataSource.testConnection()) {
                if (null == cfg) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90[%s]\u94fe\u63a5\u5f02\u5e38", (String)"DbQueryUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), "NULL"));
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90[%s]\u94fe\u63a5\u5f02\u5e38", (String)"DbQueryUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), cfg.get("number")));
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u94fe\u63a5\u5931\u8d25\uff1a%s", (String)"DbQueryUtils_2", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage()));
        }
        return dataSource;
    }

    public static int count(IDataSource ds, String sql) throws SQLException {
        DbQueryUtils.validitySelectSql(sql);
        if (ds.getType() == DBTypeEnum.SELF) {
            return DbQueryUtils.selectSelfCount(ds, sql);
        }
        Connection conn = ds.getConnection();
        if (null != conn) {
            return DbQueryUtils.selectCount(conn, sql);
        }
        return 0;
    }

    public static String buildSelectSQl(IDataSource ds, String table, String fields, String where, String group, String order, int pageSize, int page) {
        String sql = null;
        if (StringUtils.isEmpty((String)where)) {
            where = "WHERE 1=1";
        }
        if (null == group) {
            group = "";
        }
        if (StringUtils.isEmpty((String)fields)) {
            fields = "*";
        }
        page = Math.max(page, 1);
        if (pageSize < 1) {
            pageSize = 10000;
        }
        int offset = (page - 1) * pageSize;
        switch (ds.getType()) {
            case SQLSERVER: {
                sql = "SELECT " + fields + " FROM " + table.toLowerCase(Locale.ROOT) + where + " " + group + " " + order + " OFFSET " + offset + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
                break;
            }
            case ORACLE: {
                sql = "SELECT " + fields + " FROM " + table.toLowerCase(Locale.ROOT) + " " + where + " AND ROWNUM<=10000 " + group + " " + order;
                sql = "SELECT * FROM (SELECT e.*, ROWNUM AS FF_ORA_RM FROM (" + sql + ") e ) WHERE " + ORA_ROW_NUM + " BETWEEN " + offset + " AND " + pageSize;
                break;
            }
            case MYSQL: {
                sql = "SELECT " + fields + " FROM " + table.toLowerCase(Locale.ROOT) + " " + where + " " + group + " " + order + " LIMIT " + offset + "," + pageSize;
                break;
            }
            case POSTGRESQL: 
            case POSTGRESQL_NEW: {
                sql = "SELECT " + fields + " FROM " + table.toLowerCase(Locale.ROOT) + " " + where + " " + group + " " + order + " LIMIT " + pageSize + " OFFSET " + offset;
                break;
            }
            case SELF: 
            case CURRENTDB: {
                sql = "SELECT TOP " + pageSize + "," + offset + " " + fields + " FROM " + table.toLowerCase(Locale.ROOT) + " " + where + " " + group + " " + order;
            }
        }
        return sql;
    }

    public static List<Map<String, Object>> select(IDataSource ds, String sql, boolean useCache) {
        try {
            DbQueryUtils.validitySelectSql(sql);
            if (ds.getType() == DBTypeEnum.SELF) {
                if (!DbQueryUtils.containsLimitOrTop(sql)) {
                    List<Map<String, Object>> rows = null;
                    String message = "";
                    boolean err = false;
                    try {
                        String topSql = "select top 100" + sql.substring(6);
                        rows = DbQueryUtils.selectSelf(ds, topSql, useCache);
                        sql = topSql;
                    }
                    catch (Exception e) {
                        message = e.getMessage();
                        err = true;
                    }
                    if (err) {
                        err = false;
                        try {
                            String limSql = sql + " LIMIT 100";
                            rows = DbQueryUtils.selectSelf(ds, limSql, useCache);
                            sql = limSql;
                        }
                        catch (Exception e) {
                            message = message + "===========================\r\n" + e.getMessage();
                            err = true;
                        }
                    }
                    if (err) {
                        throw new KDBizException(message);
                    }
                    return rows;
                }
                return DbQueryUtils.selectSelf(ds, sql, useCache);
            }
            Connection conn = ds.getConnection();
            if (null != conn) {
                if (!DbQueryUtils.containsLimitOrTop(sql)) {
                    String whereUp = " WHERE ";
                    sql = sql.replace(" where ", whereUp);
                    sql = ds.getType() == DBTypeEnum.ORACLE ? (sql.contains(whereUp) ? sql.replaceFirst(whereUp, whereUp + "ROWNUM<=100 AND ") : sql + whereUp + "ROWNUM<=100") : (!sql.trim().endsWith(";") ? sql + " LIMIT 100" : sql.substring(0, sql.length() - 1) + " LIMIT 100");
                }
                return DbQueryUtils.select(conn, sql, useCache);
            }
            return null;
        }
        catch (Exception e) {
            if (sql.length() > 200) {
                log.error("[" + sql.substring(0, 100) + " ...... " + sql.substring(sql.length() - 100) + "]" + e.getMessage(), (Throwable)e);
            } else {
                log.error("[" + sql + "]" + e.getMessage(), (Throwable)e);
            }
            String message = e.getMessage().toLowerCase(Locale.ROOT);
            int pos = message.indexOf("error:");
            if (pos > 1) {
                message = message.substring(pos + 7);
                pos = message.indexOf("\n");
                message = message.substring(0, pos);
                throw new KDBizException(message);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u7b26\u5408\u51fd\u6570\u8bf4\u660e\uff0c\u6240\u7528\u7b26\u53f7\u662f\u5426\u51c6\u786e\uff0c\u5982\u662f\u5426\u4f7f\u7528\u82f1\u6587\u683c\u5f0f\u7684\u7b26\u53f7\u7b49\u3002", (String)"DbQueryUtils_6", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
    }

    private static boolean containsLimitOrTop(String sql) {
        if (sql.contains("ROWNUM")) {
            return true;
        }
        Pattern pattern = Pattern.compile("(?i)\\b(limit|top)\\b", 2);
        Matcher matcher = pattern.matcher(sql);
        return matcher.find();
    }

    private static void validitySelectSql(String sql) {
        if (StringUtils.isEmpty((String)sql)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u662fSQL\u8bed\u53e5\u4e0d\u5408\u6cd5", (String)"DbQueryUtils_3", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        String sqlUpperCase = sql.toUpperCase(Locale.ROOT);
        if (!sqlUpperCase.startsWith("SELECT")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301SELECT\u67e5\u8be2", (String)"DbQueryUtils_4", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        String keyword = DbQueryUtils.validitySQLKeywords(sqlUpperCase);
        if (null != keyword) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8bed\u53e5\u4e2d\u5305\u542b\u975e\u6cd5\u5173\u952e\u8bcd[%s]", (String)"DbQueryUtils_5", (String)"epm-epbs-common", (Object[])new Object[0]), keyword));
        }
    }

    private static String validitySQLKeywords(String sql) {
        for (String keyword : keywords) {
            if (!sql.contains(keyword)) continue;
            return keyword;
        }
        return null;
    }

    private static List<Map<String, Object>> selectSelf(IDataSource ds, String sql, boolean useCache) {
        if (useCache) {
            return cache.getOrLoad(sql, () -> DbQueryUtils.getRows(ds, sql));
        }
        return DbQueryUtils.getRows(ds, sql);
    }

    private static List<Map<String, Object>> getRows(IDataSource ds, String sql) {
        return (List)DB.query((DBRoute)ds.dbRoute(), (String)sql, rs -> {
            try {
                ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(16);
                while (rs.next()) {
                    rows.add(DbQueryUtils.getRow(rs));
                }
                return rows;
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        });
    }

    private static int selectSelfCount(IDataSource ds, String sql) {
        return cache.getOrLoad(sql, () -> (Integer)DB.query((DBRoute)ds.dbRoute(), (String)sql, rs -> {
            try {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }));
    }

    private static List<Map<String, Object>> select(Connection conn, String sql, boolean useCache) {
        List<Map<String, Object>> list;
        block5: {
            if (!useCache) break block5;
            List list2 = cache.getOrLoad(sql, () -> DbQueryUtils.getRows(conn, sql));
            DbQueryUtils.close(conn);
            return list2;
        }
        try {
            list = DbQueryUtils.getRows(conn, sql);
        }
        catch (Exception e) {
            try {
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable) {
                DbQueryUtils.close(conn);
                throw throwable;
            }
        }
        DbQueryUtils.close(conn);
        return list;
    }

    private static List<Map<String, Object>> getRows(Connection conn, String sql) {
        ArrayList<Map<String, Object>> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(16);
            while (rs.next()) {
                rows.add(DbQueryUtils.getRow(rs));
            }
            arrayList = rows;
        }
        catch (Exception e) {
            try {
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable) {
                DbQueryUtils.close(rs, stmt);
                throw throwable;
            }
        }
        DbQueryUtils.close(rs, stmt);
        return arrayList;
    }

    private static int selectCount(Connection conn, String sql) {
        int n;
        try {
            n = cache.getOrLoad(sql, () -> {
                Integer n;
                ResultSet rs;
                Statement stmt;
                block5: {
                    stmt = null;
                    rs = null;
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                    if (!rs.next()) break block5;
                    Integer n2 = rs.getInt(1);
                    DbQueryUtils.close(rs, stmt);
                    return n2;
                }
                try {
                    n = 0;
                }
                catch (Exception e) {
                    try {
                        throw new KDBizException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        DbQueryUtils.close(rs, stmt);
                        throw throwable;
                    }
                }
                DbQueryUtils.close(rs, stmt);
                return n;
            });
        }
        catch (Exception e) {
            try {
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable) {
                DbQueryUtils.close(conn);
                throw throwable;
            }
        }
        DbQueryUtils.close(conn);
        return n;
    }

    private static Map<String, Object> getRow(ResultSet rs) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        int count = rs.getMetaData().getColumnCount();
        int columnIndex = 1;
        while (columnIndex <= count) {
            int columnType = rs.getMetaData().getColumnType(columnIndex);
            String col = rs.getMetaData().getColumnName(columnIndex).toLowerCase(Locale.ROOT);
            if (ORA_ROW_NUM.equalsIgnoreCase(col)) {
                ++columnIndex;
                continue;
            }
            switch (columnType) {
                case -7: {
                    boolean bitValue = rs.getBoolean(columnIndex);
                    row.put(col, bitValue);
                    break;
                }
                case -6: {
                    byte tinyintValue = rs.getByte(columnIndex);
                    row.put(col, tinyintValue);
                    break;
                }
                case 5: {
                    short smallintValue = rs.getShort(columnIndex);
                    row.put(col, smallintValue);
                    break;
                }
                case 4: {
                    int integerValue = rs.getInt(columnIndex);
                    row.put(col, integerValue);
                    break;
                }
                case -5: {
                    long bigintValue = rs.getLong(columnIndex);
                    row.put(col, bigintValue);
                    break;
                }
                case 6: {
                    float floatValue = rs.getFloat(columnIndex);
                    row.put(col, Float.valueOf(floatValue));
                    break;
                }
                case 8: {
                    double doubleValue = rs.getDouble(columnIndex);
                    row.put(col, doubleValue);
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal decimalValue = rs.getBigDecimal(columnIndex);
                    row.put(col, decimalValue);
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    String stringValue = rs.getString(columnIndex);
                    row.put(col, stringValue);
                    break;
                }
                case 91: {
                    Date dateValue = rs.getDate(columnIndex);
                    row.put(col, dateValue);
                    break;
                }
                case 92: {
                    Time timeValue = rs.getTime(columnIndex);
                    row.put(col, timeValue);
                    break;
                }
                case 93: {
                    Timestamp timestampValue = rs.getTimestamp(columnIndex);
                    row.put(col, timestampValue);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] binaryValue = rs.getBytes(columnIndex);
                    row.put(col, binaryValue);
                    break;
                }
                default: {
                    row.put(col, rs.getObject(columnIndex));
                }
            }
            ++columnIndex;
        }
        return row;
    }
}

