/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epdm.common.constant.EPDMConstant;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.enums.DBTypeEnum;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;

public class ModelUtils {
    private static final String regex = "^[a-zA-Z0-9_]+$";
    private static final String[] blackChar = new String[]{"(", ")", "[", "]", ".", "`", "!", "@", "#", "$", "%", "^", "&", "*", "{", "}", "|", "?", "<", ">", "-", "=", "+", ",", ";", ":", "'", "\"", "/", "\uff08", "\uff09", "^", " ", "  "};

    public static String getTableFormModel(DynamicObject modelObject, AbsDataSource ds) {
        String table = modelObject.getString("number");
        int pos = table.indexOf("@");
        if (pos > 0) {
            String dbRoute = table.substring(pos + 1);
            if (!table.substring(0, pos).matches(regex)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\u4e0d\u652f\u6301\u76f4\u63a5\u67e5\u8be2\u3002", (String)"ModelUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), table));
            }
            if (ds.getType() == DBTypeEnum.SELF) {
                if (!StringUtils.isEmpty((String)dbRoute)) {
                    ds.setDbRoute(new DBRoute(dbRoute));
                } else {
                    ds.setDbRoute(EPDMConstant.DB_ROUTE);
                }
                table = table.substring(0, pos);
            } else {
                table = table.substring(0, pos);
            }
        } else {
            if (!table.matches(regex)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\u4e0d\u652f\u6301\u76f4\u63a5\u67e5\u8be2\u3002", (String)"ModelUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]), table));
            }
            ds.setDbRoute(EPDMConstant.DB_ROUTE);
        }
        return table;
    }

    public static String getSelectFields(DynamicObject dataModel, String from, Map<String, Integer> fieldMap, String groupFields, boolean showLabel) {
        StringBuilder selectFields = new StringBuilder();
        ArrayList<String> gFields = new ArrayList();
        if (!StringUtils.isEmpty((String)groupFields)) {
            gFields = Arrays.asList(groupFields.split(","));
        }
        if ("epdm".equalsIgnoreCase(from)) {
            String fields = EpdmDmPresetEnum.field + "," + EpdmDmPresetEnum.label;
            QFilter filter = new QFilter(EpdmDmPresetEnum.mainmodel.name(), "=", dataModel.get("id"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EpdmDmPresetEnum.getFormId(), (String)fields, (QFilter[])new QFilter[]{filter});
            for (DynamicObject dy : dynamicObjects) {
                ModelUtils.selectFields(dy, fieldMap, selectFields, gFields, showLabel);
            }
        } else {
            JSONArray dataModelFields = ModelUtils.getDataModelFields(dataModel);
            for (Object dataModelField : dataModelFields) {
                JSONObject field = (JSONObject)dataModelField;
                ModelUtils.selectFields(field, fieldMap, selectFields, gFields, showLabel);
            }
        }
        if (!StringUtils.isEmpty((String)groupFields)) {
            if (selectFields.length() < 1) {
                selectFields.append(groupFields);
            } else {
                selectFields.append(",").append(groupFields);
            }
        }
        if (null != fieldMap && !fieldMap.isEmpty()) {
            fieldMap.forEach((k, v) -> {
                if (k.contains(" AS ")) {
                    if (selectFields.length() < 1) {
                        selectFields.append((String)k);
                    } else {
                        selectFields.append(",").append((String)k);
                    }
                }
            });
        }
        return selectFields.toString();
    }

    private static void selectFields(Object obj, Map<String, Integer> fieldMap, StringBuilder selectFields, List<String> groupFields, boolean showLabel) {
        String label;
        String fieldName;
        if (obj instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)obj;
            fieldName = dy.getString("field");
            label = dy.getString("label");
        } else {
            JSONObject field = (JSONObject)obj;
            fieldName = field.getString("field");
            label = field.getString("label");
        }
        if (null != groupFields && !groupFields.isEmpty() && groupFields.contains(fieldName)) {
            return;
        }
        if (null != fieldMap && !fieldMap.containsKey(fieldName)) {
            return;
        }
        if (selectFields.length() < 1) {
            selectFields.append(fieldName);
        } else {
            selectFields.append(",").append(fieldName);
        }
        if (showLabel && !StringUtils.isEmpty((String)label)) {
            label = label.replace("-", "_");
            label = label.replace(" ", "_");
            label = label.replaceAll("\\s", "_");
            label = ModelUtils.validityASLabel(label);
            selectFields.append(" as ").append(label);
        }
    }

    public static JSONArray getDataModelFields(DynamicObject dataModel) {
        JSONObject jsonObject = ModelUtils.getDataModelDetails(dataModel);
        return jsonObject.getJSONArray("fields");
    }

    public static String getDataModelSql(DynamicObject dataModel) {
        JSONObject jsonObject = ModelUtils.getDataModelDetails(dataModel);
        return jsonObject.getString("sql_tag");
    }

    public static JSONObject getDataModelDetails(DynamicObject dataModel) {
        String details = dataModel.getString("details_tag");
        if (details.startsWith("(") && details.endsWith(")")) {
            details = details.substring(1, details.length() - 1);
        }
        return JSONObject.parseObject((String)details);
    }

    public static void validityField(String field) {
        if (StringUtils.isEmpty((String)field)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ModelUtils_2", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (field.length() > 30) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0[%s]\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26", (String)"ModelUtils_3", (String)"epm-epbs-common", (Object[])new Object[0]), field));
        }
        if (!field.matches(regex)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5b57\u6bb5\u540d\u201c%1$s\u201d\u542b\u6709\u4e0d\u5408\u6cd5\u5b57\u7b26\u3002", (String)"ModelUtils_4", (String)"epm-epbs-common", (Object[])new Object[0]), field));
        }
        if (field.matches("^\\d.*")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5b57\u6bb5\u540d\u201c%1$s\u201d\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u3002", (String)"ModelUtils_5", (String)"epm-epbs-common", (Object[])new Object[0]), field));
        }
    }

    public static String validityASLabel(String label) {
        if (StringUtils.isEmpty((String)label)) {
            return label;
        }
        if (label.length() > 100) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u63cf\u8ff0\u201c%1$s\u201d\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26", (String)"ModelUtils_9", (String)"epm-epbs-common", (Object[])new Object[0]), label));
        }
        if (label.matches("^\\d.*")) {
            label = "f_" + label;
        }
        for (String bc : blackChar) {
            label = label.replace(bc, "");
        }
        return label;
    }

    public static void validityTable(String table) {
        if (StringUtils.isEmpty((String)table)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ModelUtils_6", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (table.length() > 24) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc724\u4e2a\u5b57\u7b26", (String)"ModelUtils_7", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (!table.matches(regex)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\u201c%1$s\u201d\u542b\u6709\u4e0d\u5408\u6cd5\u5b57\u7b26\u3002", (String)"ModelUtils_8", (String)"epm-epbs-common", (Object[])new Object[0]), table));
        }
    }
}

