/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.enums.DBTypeEnum;

public class MySQLDataSource
extends AbsDataSource {
    public MySQLDataSource(DBTypeEnum type) {
        super(type);
    }

    @Override
    public String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        if (StringUtils.isEmpty((String)server)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93IP\u5730\u5740\u65e0\u6548\u3002", (String)"MySQLDataSource_3", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (port < 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u7aef\u53e3\u65e0\u6548\u3002", (String)"MySQLDataSource_2", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        String database = cfg.getString("sql_database");
        String url = "jdbc:mysql://" + server + ":" + port + "/" + database;
        url = this.getCharset(cfg, url);
        url = this.getTimezone(cfg, url);
        return url;
    }

    private String getTimezone(DynamicObject cfg, String url) {
        String serverTimezone = D.s(cfg.getString("attr1"));
        if (serverTimezone != null) {
            if (url.contains("?")) {
                if (url.contains("serverTimezone=")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u8bbe\u7f6e\u503c\u4e2d\u5df2\u7ecf\u5305\u542b\u65f6\u533a\u4fe1\u606f\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e\u65f6\u533a\u3002", (String)"MySQLDataSource_1", (String)"epm-epbs-common", (Object[])new Object[0]));
                }
                url = url + "&serverTimezone=" + this.encode(serverTimezone);
            } else {
                url = url + "?serverTimezone=" + this.encode(serverTimezone);
            }
        }
        return url;
    }

    private String getCharset(DynamicObject cfg, String url) {
        String charset = D.s(cfg.getString("charset"));
        if (charset != null) {
            url = url + "?characterEncoding=" + charset;
        }
        return url;
    }

    private String encode(String serverTimezone) {
        try {
            return URLEncoder.encode(serverTimezone, "UTF-8");
        }
        catch (UnsupportedEncodingException var3) {
            throw D.e(var3);
        }
    }
}

