/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.database;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.enums.DBTypeEnum;

public class SqlServerDataSource
extends AbsDataSource {
    public SqlServerDataSource(DBTypeEnum type) {
        super(type);
    }

    @Override
    public String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        if (StringUtils.isEmpty((String)server)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93IP\u5730\u5740\u65e0\u6548\u3002", (String)"MySQLDataSource_3", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (port < 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u7aef\u53e3\u65e0\u6548\u3002", (String)"MySQLDataSource_2", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        String database = cfg.getString("sql_database");
        return "jdbc:sqlserver://" + server + ":" + port + "; DatabaseName=" + database;
    }
}

