/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.enums;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;

public enum DataModelFieldDataTypeEnum {
    VARCHAR,
    TEXT,
    DECIMAL,
    INTEGER,
    LONG,
    BIGINT,
    BOOLEAN,
    DATETIME;


    public static DataModelFieldDataTypeEnum getBy(String name) {
        for (DataModelFieldDataTypeEnum type : DataModelFieldDataTypeEnum.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static boolean validity(String name, Object value) {
        for (DataModelFieldDataTypeEnum type : DataModelFieldDataTypeEnum.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type.validity(value);
        }
        return false;
    }

    public boolean validity(Object value) {
        switch (this) {
            case DECIMAL: {
                if (value instanceof BigDecimal) {
                    return true;
                }
                if (!(value instanceof String)) break;
                if (StringUtils.isEmpty((String)String.valueOf(value))) {
                    return false;
                }
                try {
                    new BigDecimal(String.valueOf(value));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    return true;
                }
                if (!(value instanceof String)) break;
                if (StringUtils.isEmpty((String)String.valueOf(value))) {
                    return false;
                }
                try {
                    D.x(value);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case BIGINT: 
            case LONG: {
                if (value instanceof Long) {
                    return true;
                }
                if (!(value instanceof String)) break;
                if (StringUtils.isEmpty((String)String.valueOf(value))) {
                    return false;
                }
                try {
                    Long.parseLong(String.valueOf(value));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case INTEGER: {
                if (value instanceof Integer) {
                    return true;
                }
                if (!(value instanceof String)) break;
                if (StringUtils.isEmpty((String)String.valueOf(value))) {
                    return false;
                }
                try {
                    Integer.parseInt(String.valueOf(value));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case TEXT: 
            case VARCHAR: {
                return true;
            }
            case DATETIME: {
                if (value instanceof Date) {
                    return true;
                }
                if (!(value instanceof String)) break;
                if (StringUtils.isEmpty((String)String.valueOf(value))) {
                    return false;
                }
                return D.isDateType(String.valueOf(value));
            }
        }
        return false;
    }
}

