/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.enums.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.common.enums.form.FromField;

public interface IForm {
    default public Object getObject(DynamicObject dy) {
        if (null == dy) {
            return null;
        }
        return dy.get(this.s());
    }

    default public String getString(DynamicObject dy) {
        if (null == dy) {
            return null;
        }
        return dy.getString(this.s());
    }

    default public DynamicObject getDynamicObject(DynamicObject dy) {
        if (null == dy) {
            return null;
        }
        return dy.getDynamicObject(this.s());
    }

    default public DynamicObjectCollection getDynamicObjectCollection(DynamicObject dy) {
        if (null == dy) {
            return null;
        }
        return dy.getDynamicObjectCollection(this.s());
    }

    default public Date getDate(DynamicObject dy) {
        if (null == dy) {
            return null;
        }
        return dy.getDate(this.s());
    }

    default public long getLong(DynamicObject dy) {
        if (null == dy) {
            return 0L;
        }
        return dy.getLong(this.s());
    }

    default public Boolean getBoolean(DynamicObject dy) {
        if (null == dy) {
            return false;
        }
        return D.x(dy.get(this.s()));
    }

    default public int getInt(DynamicObject dy) {
        if (null == dy) {
            return 0;
        }
        return dy.getInt(this.s());
    }

    default public BigDecimal getBigDecimal(DynamicObject dy) {
        if (null == dy) {
            return null;
        }
        return dy.getBigDecimal(this.s());
    }

    default public Map<String, Object> getMap(DynamicObject dy) {
        if (null == dy) {
            return null;
        }
        List<FromField> fields = this.fields();
        HashMap<String, Object> rs = new HashMap<String, Object>(fields.size());
        for (FromField f : fields) {
            if (!dy.containsProperty(f.getName())) continue;
            rs.put(f.getName(), dy.get(f.getName()));
        }
        return rs;
    }

    default public String ID() {
        String className = this.getClassName();
        StringBuilder result = new StringBuilder();
        int len = className.length();
        for (int i = 0; i < len; ++i) {
            char c = className.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        className = result.toString().replaceFirst("_", "");
        if (className.endsWith("_enum")) {
            int pos = className.lastIndexOf("_");
            className = className.substring(0, pos);
        }
        return className;
    }

    default public List<FromField> fields() {
        IForm[] values = this.vals();
        if (null != values && values.length > 0) {
            HashMap<String, FromField> fields = new HashMap<String, FromField>(16);
            for (IForm form : values) {
                String name = form.s();
                int pos = name.lastIndexOf("__");
                if (pos > 1) {
                    String pname = name.substring(0, pos);
                    name = name.substring(pos + 2);
                    if (!fields.containsKey(pname)) {
                        fields.put(pname, new FromField(pname));
                    }
                    ((FromField)fields.get(pname)).addChild(new FromField(name));
                    continue;
                }
                fields.put(name, new FromField(name));
            }
            return new ArrayList<FromField>(fields.values());
        }
        return null;
    }

    default public String selectFields() {
        List<FromField> fields = this.fields();
        if (null == fields || fields.isEmpty()) {
            return null;
        }
        StringBuilder selectFields = new StringBuilder();
        for (FromField field : fields) {
            if (null != field.getChildren() && !field.getChildren().isEmpty()) {
                for (FromField f : field.getChildren()) {
                    if (selectFields.length() < 1) {
                        selectFields.append(field.getName()).append(".").append(f.getName());
                        continue;
                    }
                    selectFields.append(",").append(field.getName()).append(".").append(f.getName());
                }
                continue;
            }
            if (selectFields.length() < 1) {
                selectFields.append(field.getName());
                continue;
            }
            selectFields.append(",").append(field.getName());
        }
        return selectFields.toString();
    }

    default public DynamicObject mapToDy(Map<String, Object> map) {
        List<FromField> fields = this.fields();
        DynamicObject fieldObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.ID()));
        for (FromField ff : fields) {
            if (!map.containsKey(ff.getName())) continue;
            fieldObject.set(ff.getName(), map.get(ff.getName()));
        }
        return fieldObject;
    }

    default public Map<String, FromField> mapFields() {
        List<FromField> fields = this.fields();
        if (null == fields || fields.isEmpty()) {
            return null;
        }
        HashMap<String, FromField> rs = new HashMap<String, FromField>(fields.size());
        for (FromField f : fields) {
            rs.put(f.getName(), f);
        }
        return rs;
    }

    default public IForm getBy(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        IForm[] values = this.vals();
        if (null != values && values.length > 0) {
            name = name.toLowerCase(Locale.ROOT);
            for (IForm form : values) {
                String field = form.s().toLowerCase(Locale.ROOT);
                if (!field.equals(name) && !field.startsWith(name + "__")) continue;
                return form;
            }
        }
        return null;
    }

    public String getClassName();

    public IForm[] vals();

    public String s();
}

