/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.epbs.common.util.D;

public class IDataModelUtils {
    public static DynamicObjectCollection buildEntities(DynamicObjectCollection entities, List<Map<String, Object>> mapList) {
        DynamicObject obj = !entities.isEmpty() ? (DynamicObject)entities.get(0) : entities.addNew();
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        entities.clear();
        for (Map<String, Object> r : mapList) {
            DynamicObject dy = entities.addNew();
            properties.forEach(pro -> {
                if (r.containsKey(pro.getName())) {
                    if (dy.get(pro.getName()) instanceof OrmLocaleValue) {
                        dy.set(pro.getName(), (Object)D.s(r.get(pro.getName())));
                    } else {
                        dy.set(pro.getName(), r.get(pro.getName()));
                    }
                }
            });
        }
        return entities;
    }

    public static void setEntry(IDataModel model, String entryId, DynamicObject update) {
        DynamicObjectCollection dynamicObjects = model.getEntryEntity(entryId);
        DynamicObjectCollection dynamicObjectCollection = update.getDynamicObjectCollection(entryId);
        dynamicObjectCollection.clear();
        for (DynamicObject dy : dynamicObjects) {
            DataEntityPropertyCollection props = dy.getDynamicObjectType().getProperties();
            DynamicObject sub = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            for (IDataEntityProperty prop : props) {
                String key = prop.getName();
                if (key.equalsIgnoreCase("id")) continue;
                if (dy.get(key) instanceof OrmLocaleValue) {
                    sub.set(key, (Object)LocaleString.fromMap((Map)dy.getLocaleString(key)));
                    continue;
                }
                sub.set(key, dy.get(key));
            }
            dynamicObjectCollection.add((Object)sub);
        }
    }

    public static void setModelEntry(IDataModel model, String entryId, DynamicObject update) {
        DynamicObjectCollection entities = model.getEntryEntity(entryId);
        entities.clear();
        if (null != update) {
            DynamicObjectCollection dyCollection = update.getDynamicObjectCollection(entryId);
            for (DynamicObject dy : dyCollection) {
                DynamicObject sub = entities.addNew();
                DataEntityPropertyCollection props = sub.getDynamicObjectType().getProperties();
                for (IDataEntityProperty prop : props) {
                    String key = prop.getName();
                    if (dy.get(key) instanceof OrmLocaleValue) {
                        sub.set(key, (Object)LocaleString.fromMap((Map)dy.getLocaleString(key)));
                        continue;
                    }
                    sub.set(key, dy.get(key));
                }
            }
        }
    }

    public static Set<String> getExistedFieldSet(DynamicObjectCollection selectors, String fieldKey) throws KDBizException {
        HashSet<String> fieldSet = new HashSet<String>();
        for (DynamicObject selector : selectors) {
            String field = D.s(selector.get(fieldKey));
            if (field == null) continue;
            fieldSet.add(field);
        }
        return fieldSet;
    }

    public static void mapToEntry(Map<String, Object> dataMap, DynamicObject entry, long id, Map<String, String> mapping) {
        mapping.forEach((pro, key) -> entry.set(pro, dataMap.get(key)));
        entry.set("id", (Object)id);
    }

    public static DynamicObject addNewMappingEntry(DynamicObjectCollection entries, long id, int row) {
        if (entries.size() > row) {
            return (DynamicObject)entries.get(row);
        }
        DynamicObject object = entries.addNew();
        if (object == null) {
            object = entries.addNew();
            object.set("id", (Object)id);
            object.set("seq", (Object)row);
        }
        return object;
    }

    public static int getEntryRowIndex(AbstractFormPlugin form, String entryName) {
        EntryGrid grid = (EntryGrid)form.getControl(entryName);
        if (null == grid) {
            return -1;
        }
        int[] entries = grid.getSelectRows();
        return entries[0];
    }

    public static DynamicObject insertEntries(int index, DynamicObjectCollection entries) {
        if (entries.isEmpty() || index >= entries.size()) {
            return entries.addNew();
        }
        DynamicObject sub = new DynamicObject(entries.getDynamicObjectType());
        entries.add(index, sub);
        return sub;
    }

    public static Object getEntityValue(DynamicObject dy, String id, String key) {
        boolean exist = dy.getDataEntityType().getProperties().containsKey((Object)id);
        if (exist) {
            DynamicObject obj = dy.getDynamicObject(id);
            if (null == obj) {
                return null;
            }
            exist = obj.getDataEntityType().getProperties().containsKey((Object)key);
            if (exist) {
                return obj.get(key);
            }
        }
        return null;
    }

    public static long getDynamicObjectId(String modelKey, IDataModel iModel) {
        DynamicObject dy;
        boolean exist = iModel.getDataEntity().getDataEntityType().getProperties().containsKey((Object)modelKey);
        DynamicObject dynamicObject = dy = exist ? (DynamicObject)iModel.getValue(modelKey) : null;
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("id");
    }

    public static Object getModelValue(String modelKey, IDataModel iModel, String property) {
        DynamicObject dy;
        boolean exist = iModel.getDataEntity().getDataEntityType().getProperties().containsKey((Object)modelKey);
        DynamicObject dynamicObject = dy = exist ? (DynamicObject)iModel.getValue(modelKey) : null;
        if (dy == null) {
            return 0L;
        }
        return IDataModelUtils.getObjectValue(dy, property);
    }

    public static Object getObjectValue(Object obj, String key) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)obj;
            boolean exist = dy.getDataEntityType().getProperties().containsKey((Object)key);
            if (!exist) {
                return null;
            }
            return dy.get(key);
        }
        if (obj instanceof Map) {
            Map dy = (Map)obj;
            return dy.get(key);
        }
        if (obj instanceof JSONObject) {
            JSONObject dy = (JSONObject)obj;
            return dy.get((Object)key);
        }
        if (obj instanceof IDataModel) {
            IDataModel iModel = (IDataModel)obj;
            boolean exist = iModel.getDataEntity().getDataEntityType().getProperties().containsKey((Object)key);
            return exist ? iModel.getValue(key) : null;
        }
        return null;
    }
}

