/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.epm.epdm.common.entity.EPDMDataModelPreset;

public class ListColumnEditUtil {
    public static void formatDecimalAndHideZero(PackageDataEvent e, Predicate<String> func) {
        ColumnDesc source;
        String propertyName;
        Object eSource = e.getSource();
        if (eSource instanceof ColumnDesc && func.test(propertyName = (source = (ColumnDesc)eSource).getKey())) {
            BigDecimal bigDecimal = e.getRowData().getBigDecimal(source.getFieldProp().getName());
            DecimalFormat decimalFormat = new DecimalFormat("#,###.###############");
            String value = BigDecimal.ZERO.compareTo(bigDecimal) == 0 ? null : decimalFormat.format(bigDecimal);
            e.setFormatValue((Object)value);
        }
    }

    public static ObjIntConsumer<EPDMDataModelPreset> addListColumnFunc(Map<String, String> map, List<IListColumn> listColumns) {
        return (dataModelPreset, index) -> {
            String alias = dataModelPreset.getField();
            String propertyName = (String)map.get(alias.toUpperCase(Locale.ROOT));
            if (propertyName == null) {
                return;
            }
            DecimalListColumn listColumn = alias.contains("count") ? ListColumnEditUtil.getDecimalListColumn() : new ListColumn();
            listColumn.setKey(propertyName);
            listColumn.setCaption(new LocaleString(dataModelPreset.getContent()));
            listColumn.setFieldName(propertyName);
            listColumn.setListFieldKey(propertyName);
            listColumn.setVisible(10);
            listColumn.setColumnFilter(false);
            listColumn.setColumnOrder(false);
            listColumns.add(index, (IListColumn)listColumn);
        };
    }

    private static DecimalListColumn getDecimalListColumn() {
        DecimalListColumn listColumn = new DecimalListColumn();
        listColumn.setZeroShow(false);
        return listColumn;
    }

    private ListColumnEditUtil() {
        String msg = ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"ListColumnEditUtil_1", (String)"epm-epbs-common", (Object[])new Object[]{this.getClass().getName()});
        throw new IllegalStateException(msg);
    }
}

