/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.common.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class MetadataUtil {
    public static Map<String, String> getPropertyToAlias(String entityNumber) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        MetadataUtil.getPropertyToAlias("", map, properties, alias -> !StringUtils.isEmpty((String)alias));
        return map;
    }

    public static Map<String, String> getAllProperties(String entityNumber) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        MetadataUtil.getPropertyToAlias("", map, properties, alias -> true);
        return map;
    }

    private static void getPropertyToAlias(String prefix, Map<String, String> map, DataEntityPropertyCollection properties, Predicate<String> filter) {
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectType itemPropertyType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
                MetadataUtil.getPropertyToAlias(name, map, itemPropertyType.getProperties(), filter);
                continue;
            }
            String alias = property.getAlias();
            if (!filter.test(alias)) continue;
            String key = StringUtils.isNotEmpty((String)prefix) ? prefix + "." + name : name;
            map.put(key, alias);
        }
    }

    public static Map<String, String> getAliasToPropertyName(String entityNumber) {
        Map<String, IDataEntityProperty> aliasToProperty = MetadataUtil.getAliasToProperty(entityNumber);
        HashMap<String, String> map = new HashMap<String, String>(aliasToProperty.size());
        aliasToProperty.forEach((k, v) -> map.put((String)k, v.getName()));
        return map;
    }

    public static Map<String, IDataEntityProperty> getAliasToProperty(String entityNumber) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        HashMap<String, IDataEntityProperty> map = new HashMap<String, IDataEntityProperty>(16);
        MetadataUtil.getAliasToProperty((IDataEntityType)dataEntityType, map);
        return map;
    }

    public static DBRoute getDBRoute(String metaNumber) {
        MainEntityType epdmDataQueryTask = MetadataServiceHelper.getDataEntityType((String)metaNumber);
        return new DBRoute(epdmDataQueryTask.getDBRouteKey());
    }

    public static DBRoute getDBRoute(DynamicObject dy) {
        return new DBRoute(dy.getDataEntityType().getDBRouteKey());
    }

    private static void getAliasToProperty(IDataEntityType dataEntityType, Map<String, IDataEntityProperty> map) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                DynamicObjectType itemPropertyType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
                MetadataUtil.getAliasToProperty((IDataEntityType)itemPropertyType, map);
                continue;
            }
            String alias = property.getAlias();
            if (StringUtils.isEmpty((String)alias)) continue;
            map.putIfAbsent(alias.toUpperCase(Locale.ROOT), property);
        }
    }

    private MetadataUtil() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"MetadataUtil_1", (String)"epm-epbs-common", (Object[])new Object[0]), this.getClass().getName());
        throw new IllegalStateException(msg);
    }
}

