/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.business.bd.manage.ManageImportHelper;
import kd.epm.epbs.business.bd.manage.ModelEntryGrid;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataResult;
import kd.epm.epbs.business.bd.manage.task.dto.TaskMessage;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epbs.common.util.ImportAndExportUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class BaseDataDivisionService {
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(BaseDataDivisionService.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Integer INTERVAL = 10000;
    static int MAXPAGE = 100001;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DivisionBaseDataResult execute(DivisionBaseDataInput divisionResetInput, Consumer<TaskMessage> taskConsumer, Double allModuleTaskIns) {
        long start;
        DivisionBaseDataResult result;
        block24: {
            ModelEntryGrid modelEntryGrid = divisionResetInput.getModelEntryGrid();
            result = new DivisionBaseDataResult();
            int totalNumber = ManageHelper.setTotal(modelEntryGrid);
            start = System.currentTimeMillis();
            try (SXSSFWorkbook wb = new SXSSFWorkbook(MAXPAGE);){
                XSSFCellStyle headCellStyle = ManageImportHelper.getHeadCellStyle(wb, IndexedColors.BLACK.getIndex());
                XSSFCellStyle cellStyle = ManageImportHelper.getCellStyle(wb);
                XSSFCellStyle lockCellStyle = ManageImportHelper.getLockCellStyle(wb);
                List showHeadList = modelEntryGrid.getShowFields();
                String entityName = modelEntryGrid.getEntityName();
                CopyOnWriteArrayList<SXSSFSheet> sheetList = new CopyOnWriteArrayList<SXSSFSheet>();
                ArrayList<String> hideList = new ArrayList<String>();
                showHeadList.add(0, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BaseDataDivisionService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
                ArrayList widthList = Lists.newArrayListWithExpectedSize((int)2);
                widthList.add("10");
                if (StringUtils.isNotBlank((CharSequence)entityName)) {
                    showHeadList.add(1, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599id", (String)"BaseDataDivisionService_2", (String)"epm-epbs-business", (Object[])new Object[0]));
                    widthList.add("30");
                }
                ManageImportHelper.createSheetData(totalNumber, wb, sheetList, showHeadList, headCellStyle, hideList, MAXPAGE, widthList);
                if (totalNumber > 0) {
                    int count = 1;
                    if (totalNumber > INTERVAL) {
                        count = totalNumber % INTERVAL > 0 ? totalNumber / INTERVAL + 1 : totalNumber / INTERVAL;
                    }
                    CountDownLatch latch = new CountDownLatch(count);
                    Double moduleTaskIns = allModuleTaskIns / (double)count;
                    int i = 0;
                    while (i < count) {
                        int page = i++;
                        EpbsThreadPools.commonExecute(() -> {
                            try {
                                BaseDataDivisionService.createBasicData(modelEntryGrid, page, INTERVAL, sheetList, cellStyle, lockCellStyle, taskConsumer);
                            }
                            catch (Exception e) {
                                logger.error("BaseDataDivisionService execute error", (Throwable)e);
                            }
                            finally {
                                latch.countDown();
                            }
                        });
                    }
                    try {
                        latch.await();
                        if (taskConsumer != null) {
                            taskConsumer.accept(new TaskMessage(moduleTaskIns, ""));
                        }
                        ManageImportHelper.createBasicDataObject(wb, divisionResetInput.getId(), headCellStyle);
                        result.setUrl(ImportAndExportUtil.writeFile((SXSSFWorkbook)wb, (String)divisionResetInput.getFileName()));
                    }
                    catch (InterruptedException e) {
                        logger.error("BaseDataDivisionService execute  Interrupted", (Throwable)e);
                    }
                    break block24;
                }
                if (taskConsumer != null) {
                    taskConsumer.accept(new TaskMessage(allModuleTaskIns, ""));
                }
                ManageImportHelper.createBasicDataObject(wb, divisionResetInput.getId(), headCellStyle);
                result.setUrl(ImportAndExportUtil.writeFile((SXSSFWorkbook)wb, (String)divisionResetInput.getFileName()));
            }
            catch (IOException ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
        }
        logger.info(String.format("%s--epbs--BaseDataDivisionService--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        result.setInput(divisionResetInput);
        return result;
    }

    public static void createBasicData(ModelEntryGrid entryGridModel, int page, int pageRow, List<SXSSFSheet> sheetList, XSSFCellStyle cellStyle, XSSFCellStyle lockCellStyle, Consumer<TaskMessage> taskConsumer) {
        String entityName = entryGridModel.getEntityName();
        String customSelectFields = entryGridModel.getCustomSelectFields();
        if (!StringUtils.isBlank((CharSequence)entityName)) {
            QFilter qFilter;
            QFilter[] filters = new QFilter[]{};
            if (!StringUtils.isBlank((CharSequence)entryGridModel.getFilterStr()) && (qFilter = QFilter.fromSerializedString((String)entryGridModel.getFilterStr())) != null) {
                filters = qFilter.toArray();
            }
            String selectFields = entryGridModel.getSelectFields();
            DynamicObject[] load = BusinessDataServiceHelper.load((String)entityName, (String)(selectFields + ",id"), (QFilter[])filters, (String)entryGridModel.getOrderBys(), (int)page, (int)pageRow);
            List collect = Arrays.stream(load).map(c -> c.getLong("id")).collect(Collectors.toList());
            HashMap customMap = Maps.newHashMapWithExpectedSize((int)collect.size());
            if (!StringUtils.isBlank((CharSequence)customSelectFields)) {
                DynamicObject[] customBys = BusinessDataServiceHelper.load((String)"epbs_basedata", (String)(customSelectFields + ",sourceid,type"), (QFilter[])new QFilter("sourceid", "in", collect).and(new QFilter("objectid", "=", (Object)entryGridModel.getObjectId())).toArray());
                Arrays.stream(customBys).forEach(c -> {
                    DynamicObject dynamicObject = c;
                    customMap.put(dynamicObject.getString("sourceid"), dynamicObject);
                });
            }
            BaseDataDivisionService.fillingData(load, customMap, entryGridModel, page, pageRow, sheetList, cellStyle, lockCellStyle, taskConsumer);
        } else {
            BaseDataDivisionService.createCustomData(entryGridModel, page, pageRow, sheetList, cellStyle, lockCellStyle, taskConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillingData(DynamicObject[] load, Map customMap, ModelEntryGrid entryGridModel, int page, int pageRows, List<SXSSFSheet> sheetList, XSSFCellStyle cellStyle, XSSFCellStyle lockCellStyle, Consumer<TaskMessage> taskConsumer) {
        if (load == null || load.length < 1) {
            return;
        }
        String selectFields = entryGridModel.getSelectFields();
        String customSelectFields = entryGridModel.getCustomSelectFields();
        Map<String, HashMap<String, String>> conversionMap = entryGridModel.getConversionMap();
        String[] split = selectFields.split(",");
        int realPage = MAXPAGE - 1;
        lock.lock();
        try {
            for (int i = 0; i < load.length; ++i) {
                SXSSFCell cell;
                if (taskConsumer != null) {
                    taskConsumer.accept(new TaskMessage(0.0, ""));
                }
                DynamicObject dynamicObject = load[i];
                String id = dynamicObject.getString("id");
                int startPage = page * pageRows + i + 1;
                SXSSFRow xssfRow = ManageImportHelper.getRows(startPage, realPage, sheetList, lockCellStyle, true);
                for (int n = 0; n < split.length; ++n) {
                    String name = split[n];
                    String value = dynamicObject.getString(name);
                    String realValue = ManageHelper.getRealValue(value, conversionMap, name);
                    cell = xssfRow.createCell(n + 2);
                    cell.setCellValue(realValue);
                    cell.setCellStyle((CellStyle)lockCellStyle);
                }
                SXSSFCell hideCell = xssfRow.createCell(1);
                hideCell.setCellValue(id);
                hideCell.setCellStyle((CellStyle)lockCellStyle);
                String[] csplit = StringUtils.isNotBlank((CharSequence)customSelectFields) ? customSelectFields.split(",") : new String[]{};
                for (int n = 0; n < csplit.length; ++n) {
                    DynamicObject cdynamicObject;
                    String name = csplit[n];
                    cell = xssfRow.createCell(split.length + 2 + n);
                    cell.setCellStyle((CellStyle)cellStyle);
                    if (customMap.size() <= 0 || (cdynamicObject = (DynamicObject)customMap.get(id)) == null) continue;
                    cell.setCellValue(cdynamicObject.getString(name));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createCustomData(ModelEntryGrid entryGridModel, int page, int pageRow, List<SXSSFSheet> sheetList, XSSFCellStyle cellStyle, XSSFCellStyle lockCellStyle, Consumer<TaskMessage> taskConsumer) {
        DynamicObject[] load;
        QFilter qFilter1;
        String customSelectFields = entryGridModel.getCustomSelectFields();
        QFilter qFilter2 = new QFilter("type", "=", (Object)"2");
        QFilter qFilter = new QFilter("objectid", "=", (Object)entryGridModel.getObjectId()).and(qFilter2);
        if (!StringUtils.isBlank((CharSequence)entryGridModel.getFilterStr()) && (qFilter1 = QFilter.fromSerializedString((String)entryGridModel.getFilterStr())) != null) {
            qFilter.and(qFilter1);
        }
        if ((load = BusinessDataServiceHelper.load((String)"epbs_basedata", (String)(customSelectFields + ",id,type"), (QFilter[])qFilter.toArray(), (String)"createtime,id", (int)page, (int)pageRow)) == null || load.length < 1) {
            return;
        }
        String[] split = customSelectFields.split(",");
        int realPage = MAXPAGE - 1;
        lock.lock();
        try {
            for (int i = 0; i < load.length; ++i) {
                if (taskConsumer != null) {
                    taskConsumer.accept(new TaskMessage(0.0, ""));
                }
                int startPage = page * pageRow + i + 1;
                DynamicObject dynamicObject = load[i];
                SXSSFRow xssfRow = ManageImportHelper.getRows(startPage, realPage, sheetList, lockCellStyle, true);
                for (int n = 0; n < split.length; ++n) {
                    String name = split[n];
                    String filedValue = dynamicObject.get(name).toString();
                    SXSSFCell cell = xssfRow.createCell(n + 1);
                    cell.setCellValue(filedValue);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }
}

