/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.business.bd.manage.ManageImportHelper;
import kd.epm.epbs.business.bd.manage.ModelCustomSelectField;
import kd.epm.epbs.business.bd.manage.ModelEntryGrid;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataResult;
import kd.epm.epbs.business.bd.manage.task.dto.TaskMessage;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epbs.common.util.EncryptUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class BaseDataImportDivisionService {
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(BaseDataImportDivisionService.class);
    private static final Integer INTERVAL = 6000;
    private static final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DivisionBaseDataResult execute(DivisionBaseDataInput divisionResetInput, Consumer<TaskMessage> taskConsumer, Double allModuleTaskIns) {
        long start = System.currentTimeMillis();
        ManageImportHelper.setBook(divisionResetInput.getUrl(), divisionResetInput);
        CopyOnWriteArrayList<Integer> sheetList = new CopyOnWriteArrayList<Integer>();
        CopyOnWriteArraySet pkSet = new CopyOnWriteArraySet();
        ConcurrentHashMap failMap = new ConcurrentHashMap(12);
        ModelEntryGrid modelEntryGrid = divisionResetInput.getModelEntryGrid();
        Workbook workBook = divisionResetInput.getWorkBook();
        DivisionBaseDataResult result = new DivisionBaseDataResult();
        int numberOfSheets = workBook.getNumberOfSheets();
        if (numberOfSheets < 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6570\u636e\u4e0e\u6a21\u7248\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseDataImportDivisionService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        Sheet lastSheet = workBook.getSheetAt(numberOfSheets - 1);
        BaseDataImportDivisionService.judgeBaseDataObject(lastSheet, modelEntryGrid);
        BaseDataImportDivisionService.judgeBaseDataHead(workBook, modelEntryGrid);
        int totalNumber = ManageHelper.getCountData(workBook, sheetList);
        int count = 1;
        if (totalNumber > INTERVAL) {
            count = totalNumber % INTERVAL > 0 ? totalNumber / INTERVAL + 1 : totalNumber / INTERVAL;
        }
        CountDownLatch latch = new CountDownLatch(count);
        ModelCustomSelectField customSelectFieldModel = ManageHelper.getCustomSelectFieldModel(modelEntryGrid.getObjectId().toString(), modelEntryGrid.getName());
        Double moduleTaskIns = allModuleTaskIns / (double)count;
        AtomicInteger rowCount = new AtomicInteger();
        int i = 0;
        while (i < count) {
            int page = i++;
            EpbsThreadPools.commonExecute(() -> {
                try {
                    BaseDataImportDivisionService.getBasicData(workBook, modelEntryGrid, page, sheetList, failMap, pkSet, customSelectFieldModel, rowCount, taskConsumer);
                }
                catch (Exception e) {
                    logger.error("BaseDataImportDivisionService execute error", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
            if (taskConsumer != null) {
                taskConsumer.accept(new TaskMessage(moduleTaskIns, ""));
            }
            workBook.close();
            divisionResetInput.setWorkBook(null);
            int failCount = failMap.size();
            int total = rowCount.get();
            result.setInput(divisionResetInput);
            result.setFail(SerializationUtils.toJsonString(failMap));
            result.setFailCount(failCount);
            result.setSuccessCount(total - failCount);
        }
        catch (InterruptedException e) {
            logger.error("BaseDataImportDivisionService execute  Interrupted", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("BaseDataImportDivisionService execute  Interrupted", (Throwable)e);
        }
        logger.info(String.format("%s--epbs--BaseDataImportDivisionService--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        return result;
    }

    private static void getBasicData(Workbook workBook, ModelEntryGrid modelEntryGrid, int page, CopyOnWriteArrayList<Integer> sheetList, Map<Integer, String> failMap, CopyOnWriteArraySet<String> pkSet, ModelCustomSelectField customSelectFieldModel, AtomicInteger rowCount, Consumer<TaskMessage> taskConsumer) {
        int startPage = page * INTERVAL;
        BaseDataImportDivisionService.fillingBaseData(startPage, workBook, modelEntryGrid, sheetList, failMap, pkSet, customSelectFieldModel, rowCount, taskConsumer);
    }

    private static void fillingBaseData(int startPage, Workbook workBook, ModelEntryGrid modelEntryGrid, CopyOnWriteArrayList<Integer> sheetList, Map<Integer, String> failMap, CopyOnWriteArraySet<String> pkSet, ModelCustomSelectField customSelectFieldModel, AtomicInteger rowCount, Consumer<TaskMessage> taskConsumer) {
        String pkFiled = "";
        long[] longIds = DBServiceHelper.genLongIds((String)"epbs_basedata", (int)INTERVAL);
        List actualField = customSelectFieldModel.getActualField();
        ArrayList dataSets = Lists.newArrayListWithExpectedSize((int)INTERVAL);
        String customSelectFields = modelEntryGrid.getCustomSelectFields();
        String selectFields = modelEntryGrid.getSelectFields();
        int realCount = startPage;
        int startRow = 0;
        String[] customSplit = StringUtils.isNotBlank((CharSequence)customSelectFields) ? customSelectFields.split(",") : new String[]{};
        String[] selectSplit = StringUtils.isNotBlank((CharSequence)selectFields) ? selectFields.split(",") : new String[]{};
        HashSet sourceIdSet = Sets.newHashSetWithExpectedSize((int)INTERVAL);
        HashSet fullSourceIdSet = Sets.newHashSetWithExpectedSize((int)100);
        HashSet pkIdSet = Sets.newHashSetWithExpectedSize((int)INTERVAL);
        HashMap sourceIdMap = Maps.newHashMapWithExpectedSize((int)INTERVAL);
        int index = ManageImportHelper.sheetIndex(realCount, sheetList);
        int maxData = sheetList.get(index);
        Sheet sheet = workBook.getSheetAt(index);
        for (int i = 0; i < INTERVAL; ++i) {
            if (taskConsumer != null) {
                taskConsumer.accept(new TaskMessage(0.0, ""));
            }
            ++startRow;
            if (++realCount > maxData) {
                if (index == sheetList.size() - 1) {
                    BaseDataImportDivisionService.filterData(sourceIdSet, modelEntryGrid, sourceIdMap, dataSets, failMap, actualField, pkIdSet, pkFiled, fullSourceIdSet);
                    if (dataSets.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])dataSets.toArray(new DynamicObject[0]));
                    }
                    return;
                }
                index = ManageImportHelper.sheetIndex(realCount, sheetList);
                startRow = realCount - maxData;
                maxData = sheetList.get(index);
                sheet = workBook.getSheetAt(index);
            }
            rowCount.incrementAndGet();
            String pkFiledData = BaseDataImportDivisionService.createDataSet(sheet, startRow, modelEntryGrid, longIds, i, customSplit, selectSplit, customSelectFieldModel, failMap, pkSet, dataSets, sourceIdSet, sourceIdMap, realCount, pkIdSet, fullSourceIdSet);
            if (!StringUtils.isNotBlank((CharSequence)pkFiledData)) continue;
            pkFiled = pkFiledData;
        }
        BaseDataImportDivisionService.filterData(sourceIdSet, modelEntryGrid, sourceIdMap, dataSets, failMap, actualField, pkIdSet, pkFiled, fullSourceIdSet);
        if (dataSets.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dataSets.toArray(new DynamicObject[0]));
        }
    }

    private static void filterData(HashSet<Long> sourceIdSet, ModelEntryGrid modelEntryGrid, Map<Long, Integer> sourceIdMap, List<DynamicObject> dataSets, Map<Integer, String> failMap, List<String> actualField, HashSet<String> pkIdSet, String pkFiled, HashSet<Long> fullSourceIdSet) {
        block7: {
            QFilter filter;
            List collect;
            DynamicObject[] load;
            block6: {
                List idCollect;
                DynamicObject[] load2;
                List<Long> filterSource;
                if (sourceIdSet.size() <= 0) break block6;
                QFilter filter2 = new QFilter("id", "in", sourceIdSet);
                String name = modelEntryGrid.getEntityName();
                List collect2 = QueryServiceHelper.query((String)name, (String)"id", (QFilter[])filter2.toArray()).stream().map(c -> c.getLong("id")).collect(Collectors.toList());
                Set fullCollect = fullSourceIdSet.stream().filter(c -> collect2.contains(c)).collect(Collectors.toSet());
                if (dataSets.size() > 0) {
                    dataSets = dataSets.stream().filter(c -> !fullCollect.contains(c.getLong("sourceid"))).collect(Collectors.toList());
                }
                if ((filterSource = sourceIdSet.stream().filter(c -> !collect2.contains(c)).collect(Collectors.toList())).size() > 0) {
                    filterSource.forEach(c -> {
                        Integer integer = (Integer)sourceIdMap.get(c);
                        failMap.put(integer, ResManager.loadKDString((String)"\u8be5\u57fa\u7840\u8d44\u6599\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"BaseDataImportDivisionService_2", (String)"epm-epbs-business", (Object[])new Object[0]));
                    });
                    if (dataSets.size() > 0) {
                        dataSets = dataSets.stream().filter(c -> !filterSource.contains(c.getLong("sourceid"))).collect(Collectors.toList());
                    }
                }
                if ((load2 = BusinessDataServiceHelper.load((Object[])(idCollect = QueryServiceHelper.query((String)"epbs_basedata", (String)"id", (QFilter[])(filter2 = new QFilter("sourceid", "in", sourceIdSet).and(new QFilter("objectid", "=", (Object)modelEntryGrid.getObjectId()))).toArray()).stream().map(c -> c.getLong("id")).collect(Collectors.toList())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"epbs_basedata"))) == null) break block7;
                for (int i = 0; i < load2.length; ++i) {
                    DynamicObject loadDataSet = load2[i];
                    long sourceid = loadDataSet.getLong("sourceid");
                    List filterList = dataSets.stream().filter(c -> c.getLong("sourceid") == sourceid).collect(Collectors.toList());
                    if (filterList.size() <= 0) continue;
                    DynamicObject dynamicObject = (DynamicObject)filterList.get(0);
                    actualField.forEach(c -> loadDataSet.set(c, dynamicObject.get(c)));
                    loadDataSet.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                    loadDataSet.set("modifytime", (Object)TimeServiceHelper.now());
                    dataSets.removeIf(c -> c.getLong("sourceid") == sourceid);
                    dataSets.add(loadDataSet);
                }
                break block7;
            }
            if (pkIdSet.size() > 0 && StringUtils.isNotBlank((CharSequence)pkFiled) && (load = BusinessDataServiceHelper.load((Object[])(collect = QueryServiceHelper.query((String)"epbs_basedata", (String)"id", (QFilter[])(filter = new QFilter(pkFiled, "in", pkIdSet).and(new QFilter("objectid", "=", (Object)modelEntryGrid.getObjectId()))).toArray()).stream().map(c -> c.getLong("id")).collect(Collectors.toList())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"epbs_basedata"))) != null) {
                for (int i = 0; i < load.length; ++i) {
                    DynamicObject loadDataSet = load[i];
                    String pkFiledData = loadDataSet.getString(pkFiled);
                    List filterList = dataSets.stream().filter(c -> pkFiledData.equals(c.getString(pkFiled))).collect(Collectors.toList());
                    if (filterList.size() <= 0) continue;
                    DynamicObject dynamicObject = (DynamicObject)filterList.get(0);
                    actualField.forEach(c -> loadDataSet.set(c, dynamicObject.get(c)));
                    loadDataSet.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                    loadDataSet.set("modifytime", (Object)TimeServiceHelper.now());
                    dataSets.removeIf(c -> pkFiledData.equals(c.getString(pkFiled)));
                    dataSets.add(loadDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createDataSet(Sheet sheet, int startRow, ModelEntryGrid modelEntryGrid, long[] longIds, int i, String[] customSplit, String[] selectSplit, ModelCustomSelectField customSelectFieldModel, Map<Integer, String> failMap, CopyOnWriteArraySet<String> pkSet, List<DynamicObject> dataSets, HashSet<Long> sourceIdSet, Map<Long, Integer> sourceIdMap, int realCount, HashSet<String> pkIdSet, HashSet<Long> fullSourceIdSet) {
        String pkFiled = "";
        List mustinputList = modelEntryGrid.getMustinputList();
        List isprimarykeyList = modelEntryGrid.getIsprimarykeyList();
        List actualField = customSelectFieldModel.getActualField();
        List showField = customSelectFieldModel.getShowField();
        boolean flag = false;
        DynamicObject dataSet = BusinessDataServiceHelper.newDynamicObject((String)"epbs_basedata");
        dataSet.set("id", (Object)longIds[i]);
        String idCellValue = ManageImportHelper.getCellValue(sheet, startRow, 1);
        String entityName = modelEntryGrid.getEntityName();
        List showFields = modelEntryGrid.getShowFields();
        int interval = 1;
        if (!StringUtils.isBlank((CharSequence)entityName)) {
            interval = 2;
        }
        lock.lock();
        try {
            for (int s = 0; s < customSplit.length; ++s) {
                String failInfo;
                String field = "b" + s;
                int col = selectSplit.length + s + interval;
                String cellValue = ManageImportHelper.getCellValue(sheet, startRow, col);
                if (mustinputList.contains(field) && StringUtils.isBlank((CharSequence)cellValue)) {
                    failInfo = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u5fc5\u586b\u5b57\u6bb5\u3002", (String)"BaseDataImportDivisionService_3", (String)"epm-epbs-business", (Object[])new Object[0]), showFields.get(selectSplit.length + s));
                    failMap.put(realCount, failInfo);
                    String string = null;
                    return string;
                }
                if (isprimarykeyList.contains(field)) {
                    pkFiled = (String)actualField.get(showField.indexOf(field));
                    if (!pkSet.add(cellValue)) {
                        failInfo = String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u5b57\u6bb5\u503c\"%s\"\u4e0d\u80fd\u91cd\u590d\u3002", (String)"BaseDataImportDivisionService_4", (String)"epm-epbs-business", (Object[])new Object[0]), cellValue);
                        failMap.put(realCount, failInfo);
                        String string = null;
                        return string;
                    }
                    pkIdSet.add(cellValue);
                }
                String selectFiles = (String)actualField.get(showField.indexOf(field));
                if (!StringUtils.isBlank((CharSequence)cellValue)) {
                    flag = true;
                }
                dataSet.set(selectFiles, (Object)cellValue);
            }
        }
        finally {
            lock.unlock();
        }
        if (!StringUtils.isBlank((CharSequence)entityName) && StringUtils.isNotBlank((CharSequence)idCellValue)) {
            Long sourceid = Long.parseLong(idCellValue);
            if (!pkSet.add(sourceid.toString())) {
                String failInfo = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u91cd\u590d\u3002", (String)"BaseDataImportDivisionService_5", (String)"epm-epbs-business", (Object[])new Object[0]);
                failMap.put(realCount, failInfo);
                return null;
            }
            dataSet.set("sourceid", (Object)sourceid);
            sourceIdSet.add(sourceid);
            sourceIdMap.put(sourceid, realCount);
            if (!flag) {
                fullSourceIdSet.add(sourceid);
            }
        }
        dataSet.set("type", (Object)"2");
        dataSet.set("catalogid", (Object)modelEntryGrid.getCatalogId());
        dataSet.set("objectid", (Object)modelEntryGrid.getObjectId());
        dataSet.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dataSet.set("createtime", (Object)TimeServiceHelper.now());
        dataSet.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dataSet.set("modifytime", (Object)TimeServiceHelper.now());
        dataSets.add(dataSet);
        return pkFiled;
    }

    private static void judgeBaseDataHead(Workbook workBook, ModelEntryGrid modelEntryGrid) {
        int numberOfSheets = workBook.getNumberOfSheets() - 1;
        List showFields = modelEntryGrid.getShowFields();
        String entityName = modelEntryGrid.getEntityName();
        String showData = String.join((CharSequence)",", showFields);
        int count = 1;
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            count = 2;
        }
        for (int s = 0; s < numberOfSheets; ++s) {
            Sheet sheet = workBook.getSheetAt(s);
            ArrayList readlFields = Lists.newArrayListWithExpectedSize((int)showFields.size());
            String id = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599id", (String)"BaseDataImportDivisionService_6", (String)"epm-epbs-business", (Object[])new Object[0]);
            String number = ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BaseDataImportDivisionService_7", (String)"epm-epbs-business", (Object[])new Object[0]);
            for (int i = 0; i < showFields.size() + count; ++i) {
                String cellValue;
                String string = cellValue = ManageImportHelper.getCellValue(sheet, 0, i) == null ? "" : ManageImportHelper.getCellValue(sheet, 0, i);
                if (cellValue.equals(number) || cellValue.equals(id)) continue;
                readlFields.add(cellValue);
            }
            if (readlFields != null && readlFields.size() > 0) {
                String realData = String.join((CharSequence)",", readlFields);
                if (realData.equals(showData)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5b57\u6bb5\u548c\u5f53\u524d\u57fa\u7840\u8d44\u6599\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseDataImportDivisionService_8", (String)"epm-epbs-business", (Object[])new Object[0]), "sheet" + s));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5b57\u6bb5\u548c\u5f53\u524d\u57fa\u7840\u8d44\u6599\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseDataImportDivisionService_8", (String)"epm-epbs-business", (Object[])new Object[0]), "sheet" + s));
        }
    }

    public static void judgeBaseDataObject(Sheet lastSheet, ModelEntryGrid modelEntryGrid) {
        Long objectId;
        QFilter qfilter;
        String sheetName = lastSheet.getSheetName();
        String name = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4fe1\u606f", (String)"BaseDataImportDivisionService_9", (String)"epm-epbs-business", (Object[])new Object[0]);
        if (!name.equals(sheetName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4fe1\u606f\uff0c\u9ed8\u8ba4\u68c0\u6d4b\u8868\u683c\u6700\u540e\u4e00\u4e2aSheet\u4e3a\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseDataImportDivisionService_10", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        String cellValue = ManageImportHelper.getCellValue(lastSheet, 1, 4);
        if (!StringUtils.isBlank((CharSequence)cellValue)) {
            String id = EncryptUtils.aesDecrypt((String)cellValue);
            qfilter = new QFilter("id", "=", (Object)Long.parseLong(id));
        } else {
            String numberValue = ManageImportHelper.getCellValue(lastSheet, 1, 2);
            if (!StringUtils.isBlank((CharSequence)numberValue)) {
                qfilter = new QFilter("number", "=", (Object)numberValue);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseDataImportDivisionService_11", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epbs_basedataobject", (String)"id,number,enable,name", (QFilter[])qfilter.toArray());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseDataImportDivisionService_11", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        long id = dynamicObject.getLong("id");
        if (id != (objectId = modelEntryGrid.getObjectId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseDataImportDivisionService_12", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
    }
}

