/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.business.bd.manage.ManageImportHelper;
import kd.epm.epbs.business.bd.manage.ModelEntryGrid;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataResult;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskResult;
import kd.epm.epbs.business.bd.manage.task.dto.TaskMessage;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epbs.common.util.ImportAndExportUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class BaseDataImportResultDivisionService {
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(BaseDataImportResultDivisionService.class);
    private static final Integer INTERVAL = 5000;
    static int MAXPAGE = 100001;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DivisionBaseDataResult execute(DivisionBaseDataTaskResult result, Consumer<TaskMessage> taskConsumer, Double allModuleTaskIns) {
        long start;
        DivisionBaseDataResult returnResult;
        block23: {
            returnResult = new DivisionBaseDataResult();
            DivisionBaseDataTaskInput divisionResetInput = result.getInput();
            DivisionBaseDataInput input = divisionResetInput.getInput();
            ModelEntryGrid modelEntryGrid = input.getModelEntryGrid();
            DivisionBaseDataResult divisionBaseDataResult = result.getResult();
            ConcurrentHashMap failMap = (ConcurrentHashMap)SerializationUtils.fromJsonString((String)divisionBaseDataResult.getFail(), ConcurrentHashMap.class);
            if (failMap.size() < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5931\u8d25\u6570\u636e\u5b58\u5728\u95ee\u9898\u3002", (String)"BaseDataImportResultDivisionService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            List<Integer> keyList = failMap.keySet().stream().map(c -> Integer.parseInt(c)).collect(Collectors.toList());
            keyList.sort(Integer::compareTo);
            CopyOnWriteArrayList sortList = new CopyOnWriteArrayList();
            keyList.forEach(c -> sortList.add(c));
            ManageImportHelper.setBook(input.getUrl(), input);
            Workbook workBook = input.getWorkBook();
            CopyOnWriteArrayList<Integer> importSheetList = new CopyOnWriteArrayList<Integer>();
            ManageHelper.getCountData(workBook, importSheetList);
            int totalNumber = divisionBaseDataResult.getFailCount();
            start = System.currentTimeMillis();
            try (SXSSFWorkbook wb = new SXSSFWorkbook(MAXPAGE);){
                XSSFCellStyle headCellStyle = ManageImportHelper.getHeadCellStyle(wb, IndexedColors.BLACK.getIndex());
                XSSFCellStyle cellStyle = ManageImportHelper.getCellStyle(wb);
                XSSFCellStyle lockCellStyle = ManageImportHelper.getLockCellStyle(wb);
                XSSFCellStyle lockErrorCellStyle = ManageImportHelper.getLockErrorCellStyle(wb);
                List showHeadList = modelEntryGrid.getShowFields();
                CopyOnWriteArrayList<SXSSFSheet> sheetList = new CopyOnWriteArrayList<SXSSFSheet>();
                String entityName = modelEntryGrid.getEntityName();
                BaseDataImportResultDivisionService.createSheetData(totalNumber, wb, sheetList, showHeadList, headCellStyle, entityName);
                if (totalNumber <= 0) break block23;
                int count = 1;
                if (totalNumber > INTERVAL) {
                    count = totalNumber % INTERVAL > 0 ? totalNumber / INTERVAL + 1 : totalNumber / INTERVAL;
                }
                CountDownLatch latch = new CountDownLatch(count);
                Double moduleTaskIns = allModuleTaskIns / (double)count;
                int i = 0;
                while (i < count) {
                    int page = i++;
                    EpbsThreadPools.commonExecute(() -> {
                        try {
                            BaseDataImportResultDivisionService.createBasicData(modelEntryGrid, page, INTERVAL, sheetList, cellStyle, lockCellStyle, lockErrorCellStyle, failMap, sortList, workBook, importSheetList, taskConsumer);
                        }
                        catch (Exception e) {
                            logger.error("BaseDataImportResultDivisionService execute error", (Throwable)e);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                try {
                    latch.await();
                    if (taskConsumer != null) {
                        taskConsumer.accept(new TaskMessage(moduleTaskIns, ""));
                    }
                    workBook.close();
                    input.setWorkBook(null);
                    String fileName = input.getFileName();
                    int dotIndex = fileName.lastIndexOf(".");
                    if (dotIndex != -1) {
                        fileName = fileName.substring(0, dotIndex);
                    }
                    String failName = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_", (String)"BaseDataImportResultDivisionService_2", (String)"epm-epbs-business", (Object[])new Object[0]);
                    ManageImportHelper.createBasicDataObject(wb, modelEntryGrid.getObjectId().toString(), headCellStyle);
                    returnResult.setUrl(ImportAndExportUtil.writeFile((SXSSFWorkbook)wb, (String)(failName + fileName)));
                }
                catch (InterruptedException e) {
                    logger.error("BaseDataImportResultDivisionService execute  Interrupted", (Throwable)e);
                }
            }
            catch (IOException ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
        }
        logger.info(String.format("%s--epbs--BaseDataImportResultDivisionService--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        return returnResult;
    }

    private static void createSheetData(int totalNumber, SXSSFWorkbook wb, List<SXSSFSheet> sheetList, List showHeadList, XSSFCellStyle headCellStyle, String entityName) {
        ArrayList<String> hideList = new ArrayList<String>();
        showHeadList.add(0, ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"BaseDataImportResultDivisionService_3", (String)"epm-epbs-business", (Object[])new Object[0]));
        showHeadList.add(1, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BaseDataImportResultDivisionService_4", (String)"epm-epbs-business", (Object[])new Object[0]));
        ArrayList widthList = Lists.newArrayListWithExpectedSize((int)2);
        widthList.add("30");
        widthList.add("10");
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            showHeadList.add(2, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599id", (String)"BaseDataImportResultDivisionService_5", (String)"epm-epbs-business", (Object[])new Object[0]));
            widthList.add("30");
        }
        ManageImportHelper.createSheetData(totalNumber, wb, sheetList, showHeadList, headCellStyle, hideList, MAXPAGE, widthList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBasicData(ModelEntryGrid entryGridModel, int page, int pageRow, List<SXSSFSheet> sheetList, XSSFCellStyle cellStyle, XSSFCellStyle lockCellStyle, XSSFCellStyle lockErrorCellStyle, ConcurrentHashMap<String, String> failMap, CopyOnWriteArrayList<Integer> sortList, Workbook workBook, CopyOnWriteArrayList<Integer> importSheetList, Consumer<TaskMessage> taskConsumer) {
        String selectFields = entryGridModel.getSelectFields();
        String customSelectFields = entryGridModel.getCustomSelectFields();
        String[] split = StringUtils.isNotBlank((CharSequence)selectFields) ? selectFields.split(",") : new String[]{};
        String[] csplit = StringUtils.isNotBlank((CharSequence)customSelectFields) ? customSelectFields.split(",") : new String[]{};
        int realPage = MAXPAGE - 1;
        int index = ManageImportHelper.sheetIndex(page * pageRow, importSheetList);
        int maxData = importSheetList.get(index);
        Sheet sheet = workBook.getSheetAt(index);
        int laseMaxData = index == 0 ? 0 : importSheetList.get(index - 1);
        int count = 1;
        if (StringUtils.isNotBlank((CharSequence)entryGridModel.getEntityName())) {
            count = 3;
        }
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            for (int i = 0; i < pageRow; ++i) {
                int startPage;
                Integer integer;
                if (taskConsumer != null) {
                    taskConsumer.accept(new TaskMessage(0.0, ""));
                }
                if ((integer = sortList.get(startPage = page * pageRow + i)) == null) {
                    return;
                }
                int integerData = integer;
                String failInfo = failMap.get(integer.toString());
                if (integer > maxData) {
                    if (index == importSheetList.size() - 1) {
                        return;
                    }
                    index = ManageImportHelper.sheetIndex(integer, importSheetList);
                    laseMaxData = index == 0 ? maxData : importSheetList.get(index - 1);
                    maxData = importSheetList.get(index);
                    sheet = workBook.getSheetAt(index);
                }
                SXSSFRow xssfRow = ManageImportHelper.getRows(startPage + 1, realPage, sheetList, lockCellStyle, false);
                SXSSFCell hideCell = xssfRow.createCell(0);
                hideCell.setCellValue(failInfo);
                hideCell.setCellStyle((CellStyle)lockErrorCellStyle);
                int row = integerData - laseMaxData;
                if (StringUtils.isNotBlank((CharSequence)selectFields)) {
                    for (int n = 0; n < split.length + count; ++n) {
                        String cellValue = ManageImportHelper.getCellValue(sheet, row, n);
                        SXSSFCell cell = xssfRow.createCell(n + 1);
                        cell.setCellValue(cellValue);
                        cell.setCellStyle((CellStyle)lockCellStyle);
                    }
                }
                boolean flag = false;
                if (!StringUtils.isNotBlank((CharSequence)customSelectFields)) continue;
                int interval = split.length + (count - 1);
                int length = csplit.length;
                if (StringUtils.isBlank((CharSequence)entryGridModel.getEntityName())) {
                    ++length;
                    flag = true;
                }
                for (int n = 0; n < length; ++n) {
                    String cellValue = ManageImportHelper.getCellValue(sheet, row, interval + n);
                    SXSSFCell cell = xssfRow.createCell(split.length + count + n);
                    if (flag && n == 0) {
                        cell.setCellStyle((CellStyle)lockCellStyle);
                    } else {
                        cell.setCellStyle((CellStyle)cellStyle);
                    }
                    cell.setCellValue(cellValue);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }
}

