/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;

public class EntityMetadata {
    private final Map<String, RefFieldProp> refFieldPropMap = new LinkedHashMap<String, RefFieldProp>();
    private final Map<String, RefFieldProp> refBaseFieldPropMap = new LinkedHashMap<String, RefFieldProp>();

    public EntityMetadata(String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        this.parseRefFieldPropMap((IDataEntityType)dataEntityType, "", "");
    }

    private void parseRefFieldPropMap(IDataEntityType dt, String prefixName, String prefixDisplayName) {
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if ("_lk".endsWith(name) || "_id".endsWith(name)) continue;
            if (property instanceof IBasedataField) {
                this.parseRefFieldPropMap(((IBasedataField)property).getComplexType(), EntityMetadata.append(prefixName, property.getName()), EntityMetadata.append(prefixDisplayName, property.getDisplayName().toString()));
                this.refBaseFieldPropMap.put(EntityMetadata.append(prefixName, property.getName()), new RefFieldProp(property, prefixName, prefixDisplayName));
                continue;
            }
            if (property instanceof EntryProp) {
                this.parseRefFieldPropMap(((EntryProp)property).getItemType(), EntityMetadata.append(prefixName, property.getName()), EntityMetadata.append(prefixDisplayName, property.getDisplayName().toString()));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)property.getAlias())) continue;
            this.refFieldPropMap.put(EntityMetadata.append(prefixName, name), new RefFieldProp(property, prefixName, prefixDisplayName));
        }
        RefFieldProp idRefFieldProp = new RefFieldProp(EntityMetadata.append(prefixName, dt.getPrimaryKey().getName()), EntityMetadata.append(prefixDisplayName, ResManager.loadKDString((String)"\u5185\u7801", (String)"EntityMetadata_1", (String)"epm-epbs-business", (Object[])new Object[0])));
        this.refFieldPropMap.put(idRefFieldProp.getName(), idRefFieldProp);
    }

    public RefFieldProp getRefFieldProp(String fieldKey) {
        IDataEntityProperty refProp;
        String prefixName;
        RefFieldProp basedataProp;
        RefFieldProp refFieldProp = this.refFieldPropMap.get(fieldKey);
        if (refFieldProp == null && fieldKey.contains(".") && (basedataProp = this.refBaseFieldPropMap.get(prefixName = fieldKey.substring(0, fieldKey.lastIndexOf(".")))) != null) {
            IDataEntityProperty prop = basedataProp.getRefProp();
            String endName = fieldKey.substring(fieldKey.lastIndexOf(".") + 1);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((IBasedataField)prop).getBaseEntityId());
            DynamicProperty typeProperty = dataEntityType.getProperty(endName);
            refFieldProp = new RefFieldProp((IDataEntityProperty)typeProperty, basedataProp.getName(), basedataProp.getDisplayName());
        }
        if (refFieldProp != null && ((refProp = refFieldProp.getRefProp()) instanceof BillStatusProp || refProp instanceof BooleanProp || refProp instanceof ComboProp)) {
            refFieldProp.setConversion("1");
        }
        return refFieldProp;
    }

    public static String append(String prefix, String field) {
        if (prefix != null && prefix.length() > 0) {
            field = prefix + "." + field;
        }
        return field;
    }

    public static class RefFieldProp {
        IDataEntityProperty refProp;
        private final String name;
        private final String displayName;
        private String conversion = "0";

        public RefFieldProp(IDataEntityProperty refProp, String prefixName, String prefixDisplayName) {
            this.refProp = refProp;
            this.name = EntityMetadata.append(prefixName, refProp.getName());
            LocaleString displayName = refProp.getDisplayName();
            this.displayName = EntityMetadata.append(prefixDisplayName, displayName == null ? "" : displayName.toString());
        }

        public RefFieldProp(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public IDataEntityProperty getRefProp() {
            return this.refProp;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getConversion() {
            return this.conversion;
        }

        public void setConversion(String conversion) {
            this.conversion = conversion;
        }
    }
}

