/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.manage.CopyFormResult;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.NumberRuleUtils;

public class ManageCopyHepler {
    public static final String COPY_POSTFIX = "_copy";

    public static void openWindow(IFormView view, IFormPlugin plugin, Long sourceId, String title) {
        String formId = "epbs_basedataobject_copy";
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("sourceId", (Object)sourceId);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(title);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        view.showForm(formShowParameter);
    }

    public static CopyFormResult copyData(IFormView view, Long soucreId, String newNumber, Object newName) {
        if (soucreId == null || soucreId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c!", (String)"ManageCopyHepler_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            return null;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)newNumber) || kd.bos.util.StringUtils.isEmpty((String)newName.toString())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u548c\u540d\u79f0\u3002", (String)"ManageCopyHepler_2", (String)"epm-epbs-business", (Object[])new Object[0]));
            return null;
        }
        if (!NumberRuleUtils.checkNumberV2((String)newNumber)) {
            view.showTipNotification(NumberRuleUtils.getMessageV2());
            return null;
        }
        CopyFormResult formResult = new CopyFormResult();
        formResult.setSoucreId(soucreId);
        QFilter qf = new QFilter("number", "=", (Object)newNumber);
        if (QueryServiceHelper.exists((String)"epbs_basedataobject", (QFilter[])qf.toArray())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ManageCopyHepler_3", (String)"epm-epbs-business", (Object[])new Object[0]));
            return null;
        }
        DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)soucreId, (String)"epbs_basedataobject");
        if (templateDy != null) {
            Long newId = GlobalIdUtil.genGlobalLongId();
            formResult.setNewId(newId);
            formResult.setNewNumber(newNumber);
            formResult.setNewName(newName);
        }
        return formResult;
    }

    public static Long actionCopy(Object selectId, Object newName, String newNumber, long newId) {
        ArrayList cidList = new ArrayList(16);
        ArrayList newCidList = new ArrayList(16);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectId, (String)"epbs_basedataobject");
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)dynamicObject);
        if (StringUtils.isBlank((Object)newName)) {
            Object name = clone.get("name");
            if (name instanceof Map) {
                Map nameMap = (Map)name;
                HashMap newMap = new HashMap(nameMap.size());
                for (Map.Entry entry : nameMap.entrySet()) {
                    newMap.put(entry.getKey(), entry.getValue() + COPY_POSTFIX);
                }
                clone.set("name", newMap);
            } else {
                clone.set("name", (Object)name.toString());
            }
        } else {
            clone.set("name", newName);
        }
        if (StringUtils.isBlank((CharSequence)newNumber)) {
            clone.set("number", (Object)(clone.getString("number") + COPY_POSTFIX));
        } else {
            clone.set("number", (Object)newNumber);
        }
        clone.set("id", (Object)newId);
        clone.set("creator", (Object)RequestContext.get().getCurrUserId());
        clone.set("createtime", (Object)TimeServiceHelper.now());
        clone.set("modifier", (Object)RequestContext.get().getCurrUserId());
        clone.set("modifytime", (Object)TimeServiceHelper.now());
        clone.set("mtype", (Object)"2");
        DynamicObjectCollection entryentity = clone.getDynamicObjectCollection("entryentity");
        entryentity.stream().forEach(c -> c.set("id", (Object)GlobalIdUtil.genGlobalLongId()));
        DynamicObjectCollection centryentity = clone.getDynamicObjectCollection("centryentity");
        centryentity.stream().forEach(c -> {
            long id = GlobalIdUtil.genGlobalLongId();
            newCidList.add(id);
            c.set("id", (Object)id);
        });
        DynamicObjectCollection yCentryentity = dynamicObject.getDynamicObjectCollection("centryentity");
        yCentryentity.stream().forEach(c -> cidList.add(c.getLong("id")));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{clone});
        return newId;
    }
}

