/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataInput;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.epm.epbs.common.util.ImportAndExportUtil;
import kd.epm.epbs.common.util.ThrowableHelper;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ManageImportHelper {
    public static final String TIMES_NEW_ROMAN = ConfigurationContext.INSTANCE.loadProp(AppTypeEnum.EPBS.getAppNum(), (IAppConfigProp)AppConfigPropEnum.BASEDATA_IMPORT_TYPEFACE);
    public static final int DEFAULTCOLUMNWIDTH = 400;
    static short BORDERCOLOR = 0;
    public static final int HIDEINTERVAL = 20;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String handleExportData(DynamicObjectCollection toExportData, List<String> headerList, List<String> showHeadList, List<String> widthList, Map<String, HashMap<String, String>> conversionMap, String fileName) {
        if (toExportData == null) throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ManageImportHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        if (toExportData.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ManageImportHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try (XSSFWorkbook workBook = new XSSFWorkbook();){
            XSSFCellStyle style = workBook.createCellStyle();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFCellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            XSSFFont headFont = workBook.createFont();
            headFont.setBold(true);
            headFont.setFontHeightInPoints((short)11);
            headFont.setFontName(TIMES_NEW_ROMAN);
            headerStyle.setFont((Font)headFont);
            XSSFFont dataFont = workBook.createFont();
            dataFont.setBold(false);
            dataFont.setFontHeightInPoints((short)11);
            dataFont.setFontName(TIMES_NEW_ROMAN);
            style.setFont((Font)dataFont);
            XSSFSheet xssfSheet = workBook.createSheet();
            xssfSheet.setDefaultRowHeight((short)512);
            xssfSheet.autoSizeColumn(0);
            int rowNum = 0;
            XSSFRow headerRow1 = xssfSheet.createRow(rowNum);
            headerRow1.setHeight((short)512);
            for (int i = 0; i < showHeadList.size(); ++i) {
                XSSFCell cell = headerRow1.createCell(i, CellType.STRING);
                cell.setCellValue(showHeadList.get(i));
                cell.setCellStyle((CellStyle)headerStyle);
                if (widthList != null && i < widthList.size()) {
                    xssfSheet.setColumnWidth(i, Integer.parseInt(widthList.get(i)) * 256);
                    continue;
                }
                xssfSheet.setColumnWidth(i, showHeadList.get(i).getBytes().length * 256 + 400);
            }
            ++rowNum;
            Object string = toExportData.iterator();
            while (true) {
                XSSFRow xssfRow;
                DynamicObject rowData;
                if (string.hasNext()) {
                    rowData = (DynamicObject)string.next();
                    xssfRow = xssfSheet.createRow(rowNum);
                    xssfRow.setHeight((short)512);
                } else {
                    string = ImportAndExportUtil.writeFile((XSSFWorkbook)workBook, (String)fileName);
                    return string;
                }
                for (int i = 0; i < headerList.size(); ++i) {
                    String value;
                    String name = headerList.get(i);
                    Object obj = rowData.get(name);
                    String string2 = value = obj == null ? "" : obj.toString();
                    if (obj instanceof Timestamp) {
                        Timestamp time = (Timestamp)obj;
                        value = sdf.format(new Date(time.getTime()));
                    }
                    XSSFCell cell = xssfRow.createCell(i);
                    cell.setCellValue(ManageHelper.getRealValue(value, conversionMap, name));
                    cell.setCellStyle((CellStyle)style);
                }
                ++rowNum;
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static XSSFCellStyle getHeadCellStyle(SXSSFWorkbook wb, short color) {
        XSSFCellStyle headStyle = wb.getXSSFWorkbook().createCellStyle();
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setBorderTop(BorderStyle.THIN);
        headStyle.setBorderRight(BorderStyle.THIN);
        headStyle.setBorderBottom(BorderStyle.THIN);
        headStyle.setBorderLeft(BorderStyle.THIN);
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headStyle.setBottomBorderColor(BORDERCOLOR);
        headStyle.setLocked(true);
        headStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        XSSFFont headFont = wb.getXSSFWorkbook().createFont();
        headFont.setBold(true);
        headFont.setFontHeightInPoints((short)11);
        headFont.setFontName(TIMES_NEW_ROMAN);
        headFont.setColor(color);
        headStyle.setFont((Font)headFont);
        return headStyle;
    }

    public static XSSFCellStyle getCellStyle(SXSSFWorkbook wb) {
        XSSFCellStyle style = wb.getXSSFWorkbook().createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLocked(false);
        XSSFFont dataFont = wb.getXSSFWorkbook().createFont();
        dataFont.setBold(false);
        dataFont.setFontHeightInPoints((short)11);
        dataFont.setFontName(TIMES_NEW_ROMAN);
        style.setFont((Font)dataFont);
        return style;
    }

    public static XSSFCellStyle getLockCellStyle(SXSSFWorkbook wb) {
        XSSFCellStyle style = ManageImportHelper.getCellStyle(wb);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBottomBorderColor(BORDERCOLOR);
        style.setLocked(true);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        return style;
    }

    public static XSSFCellStyle getLockErrorCellStyle(SXSSFWorkbook wb) {
        XSSFCellStyle style = ManageImportHelper.getCellStyle(wb);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBottomBorderColor(BORDERCOLOR);
        style.setLocked(true);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        XSSFFont font = style.getFont();
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont((Font)font);
        return style;
    }

    public static SXSSFSheet createSheet(String sheetName, SXSSFWorkbook wb, List<String> showHeadList, XSSFCellStyle headCellStyle, List<String> widthList, List<String> hideList) {
        SXSSFCell cell;
        XSSFCellStyle mulHeadCellStyle = ManageImportHelper.getHeadCellStyle(wb, IndexedColors.RED.getIndex());
        SXSSFSheet xssfSheet = wb.createSheet(sheetName);
        xssfSheet.setDefaultRowHeight((short)512);
        int rowNum = 0;
        SXSSFRow headerRow = xssfSheet.createRow(rowNum);
        headerRow.setHeight((short)512);
        String errorName = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"ManageImportHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]);
        for (int i = 0; i < showHeadList.size(); ++i) {
            String name = showHeadList.get(i);
            cell = headerRow.createCell(i, CellType.STRING);
            cell.setCellValue(name);
            if (errorName.equals(name)) {
                cell.setCellStyle((CellStyle)mulHeadCellStyle);
            } else {
                cell.setCellStyle((CellStyle)headCellStyle);
            }
            if (widthList != null && i < widthList.size()) {
                xssfSheet.setColumnWidth(i, Integer.parseInt(widthList.get(i)) * 256);
                continue;
            }
            xssfSheet.setColumnWidth(i, showHeadList.get(i).getBytes().length * 256 + 400);
        }
        if (hideList != null && hideList.size() > 0) {
            int start = showHeadList.size() + 20;
            headCellStyle.setHidden(true);
            for (int i = 0; i < hideList.size(); ++i) {
                cell = headerRow.createCell(start + i, CellType.STRING);
                cell.setCellValue(hideList.get(i));
                cell.setCellStyle((CellStyle)headCellStyle);
                xssfSheet.setColumnWidth(start + i, -1);
            }
        }
        return xssfSheet;
    }

    public static String getCellValueByCell(CellBase cell) {
        if (cell == null || "".equals(cell.toString().trim())) {
            return "";
        }
        String cellValue = "";
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    sdf = format == 20 || format == 32 ? new SimpleDateFormat("HH:mm") : (format == 14 || format == 31 || format == 57 || format == 58 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new KDBizException("exception on get date data !".concat(e.toString()));
                    }
                }
                DecimalFormat df = new DecimalFormat("0.####");
                BigDecimal bd = new BigDecimal(String.valueOf(cell.getNumericCellValue()));
                String plainString = bd.toPlainString();
                boolean containsDotZero = String.valueOf(plainString).contains(".0");
                if (containsDotZero) {
                    cellValue = df.format(Double.parseDouble(plainString));
                    break;
                }
                cellValue = plainString;
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (CellType.NUMERIC == cachedFormulaResultType) {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                if (CellType.STRING != cachedFormulaResultType) break;
                cellValue = cell.getStringCellValue();
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "ERROR VALUE";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }

    public static String getCellValue(Sheet sheet, int row, int col) {
        if (sheet.getRow(row) == null || sheet.getRow(row).getCell(col) == null) {
            return null;
        }
        return ManageImportHelper.getCellValueByCell((CellBase)sheet.getRow(row).getCell(col));
    }

    public static void setBook(String url, DivisionBaseDataInput divisionBaseDataInput) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(url);){
            HSSFWorkbook workBook = null;
            if (url.endsWith("xls")) {
                workBook = new HSSFWorkbook(inputStream);
            } else if (url.endsWith("xlsx")) {
                workBook = new XSSFWorkbook(inputStream);
            }
            divisionBaseDataInput.setWorkBook((Workbook)workBook);
        }
        catch (Exception e) {
            if (e instanceof NotOfficeXmlFileException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"ManageImportHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    public static void createSheetData(int totalNumber, SXSSFWorkbook wb, List<SXSSFSheet> sheetList, List showHeadList, XSSFCellStyle headCellStyle, List<String> hideList, int MAXPAGE, List<String> widthList) {
        int realPage = MAXPAGE - 1;
        if (totalNumber > realPage) {
            int sheetCount = totalNumber % realPage > 0 ? totalNumber / realPage + 1 : totalNumber / realPage;
            for (int i = 0; i < sheetCount; ++i) {
                String sheetName = "sheet" + i;
                SXSSFSheet sheet = ManageImportHelper.createSheet(sheetName, wb, showHeadList, headCellStyle, widthList, hideList);
                sheetList.add(sheet);
            }
        } else {
            String sheetName = "sheet0";
            SXSSFSheet sheet = ManageImportHelper.createSheet(sheetName, wb, showHeadList, headCellStyle, widthList, hideList);
            sheetList.add(sheet);
        }
    }

    public static void createBasicDataObject(SXSSFWorkbook wb, String id, XSSFCellStyle headCellStyle) {
        long catalog;
        DynamicObject catalogDynamicObject;
        DynamicObject dynamicObject;
        XSSFCellStyle lockCellStyle = ManageImportHelper.getLockCellStyle(wb);
        SXSSFSheet sheet = wb.createSheet(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4fe1\u606f", (String)"ManageImportHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]));
        sheet.protectSheet("kingdee");
        sheet.setDefaultRowHeight((short)512);
        int rowNum = 0;
        ArrayList showHeadList = Lists.newArrayListWithExpectedSize((int)4);
        showHeadList.add(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u76ee\u5f55\u7f16\u7801", (String)"ManageImportHelper_5", (String)"epm-epbs-business", (Object[])new Object[0]));
        showHeadList.add(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u76ee\u5f55\u540d\u79f0", (String)"ManageImportHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]));
        showHeadList.add(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u7f16\u7801", (String)"ManageImportHelper_7", (String)"epm-epbs-business", (Object[])new Object[0]));
        showHeadList.add(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u540d\u79f0", (String)"ManageImportHelper_8", (String)"epm-epbs-business", (Object[])new Object[0]));
        SXSSFRow headerRow = sheet.createRow(rowNum);
        headerRow.setHeight((short)512);
        for (int i = 0; i < showHeadList.size(); ++i) {
            SXSSFCell cell = headerRow.createCell(i, CellType.STRING);
            cell.setCellValue((String)showHeadList.get(i));
            cell.setCellStyle((CellStyle)headCellStyle);
            sheet.setColumnWidth(i, ((String)showHeadList.get(i)).getBytes().length * 256 + 400);
        }
        SXSSFCell hidecell = headerRow.createCell(showHeadList.size(), CellType.STRING);
        hidecell.setCellStyle((CellStyle)headCellStyle);
        sheet.setColumnWidth(showHeadList.size(), 0);
        lockCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        if (StringUtils.isNotBlank((CharSequence)id) && (dynamicObject = QueryServiceHelper.queryOne((String)"epbs_basedataobject", (String)"id,number,name,catalog", (QFilter[])new QFilter("id", "in", (Object)Long.parseLong(id)).toArray())) != null && (catalogDynamicObject = QueryServiceHelper.queryOne((String)"epbs_basedatacatalog", (String)"id,number,name", (QFilter[])new QFilter("id", "in", (Object)(catalog = dynamicObject.getLong("catalog"))).toArray())) != null) {
            SXSSFRow xssfRow = sheet.createRow(1);
            xssfRow.setHeight((short)512);
            SXSSFCell cell = xssfRow.createCell(0);
            cell.setCellValue(catalogDynamicObject.getString("number"));
            cell.setCellStyle((CellStyle)lockCellStyle);
            cell = xssfRow.createCell(1);
            cell.setCellValue(catalogDynamicObject.getString("name"));
            cell.setCellStyle((CellStyle)lockCellStyle);
            cell = xssfRow.createCell(2);
            cell.setCellValue(dynamicObject.getString("number"));
            cell.setCellStyle((CellStyle)lockCellStyle);
            cell = xssfRow.createCell(3);
            cell.setCellValue(dynamicObject.getString("name"));
            cell.setCellStyle((CellStyle)lockCellStyle);
            cell = xssfRow.createCell(4);
            cell.setCellValue(EncryptUtils.aesEncrypt((String)dynamicObject.getString("id")));
            cell.setCellStyle((CellStyle)lockCellStyle);
        }
    }

    public static SXSSFRow getRows(int startPage, int realPage, List<SXSSFSheet> sheetList, XSSFCellStyle lockCellStyle, boolean needNumber) {
        SXSSFSheet rows;
        int createPage = startPage;
        if (startPage > realPage) {
            int index = startPage % realPage > 0 ? startPage / realPage + 1 : startPage / realPage;
            rows = sheetList.get(index - 1);
            createPage = startPage - realPage * (index - 1);
        } else {
            rows = sheetList.get(0);
        }
        SXSSFRow xssfRow = rows.createRow(createPage);
        xssfRow.setHeight((short)512);
        if (needNumber) {
            SXSSFCell xhCell = xssfRow.createCell(0);
            xhCell.setCellValue((double)startPage);
            xhCell.setCellStyle((CellStyle)lockCellStyle);
        }
        return xssfRow;
    }

    public static int sheetIndex(int realCount, CopyOnWriteArrayList<Integer> sheetList) {
        int sheetIndex = 0;
        for (int i = 0; i < sheetList.size(); ++i) {
            Integer integer = sheetList.get(i);
            if (realCount >= integer) continue;
            sheetIndex = i;
            return sheetIndex;
        }
        return sheetIndex;
    }
}

