/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.QFBuilder;

public class ManageTreeHelper {
    private String treeViewctrlName;
    private AbstractFormPlugin plugIn;
    private String cache_headnodeid;
    private String cache_focusnodeid;
    private String cache_treeList;

    public void setCache_focusnodeid(String focusnodeid) {
        this.cache_focusnodeid = focusnodeid;
    }

    public void setCache_headnodeid(String headnodeid) {
        this.cache_headnodeid = headnodeid;
    }

    public void setCache_treeList(String cache_treeList) {
        this.cache_treeList = cache_treeList;
    }

    public void setTreeViewctrlName(String treeViewctrlName) {
        this.treeViewctrlName = treeViewctrlName;
    }

    public void initTree(String newId, AbstractFormPlugin plugIn) {
        Map<String, String> memberMap;
        String rootId = null;
        TreeNode root = new TreeNode();
        QFBuilder qb = new QFBuilder();
        this.plugIn = plugIn;
        QFBuilder strategyFilter = ManageHelper.getStrategyFilter();
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"epbs_basedatacatalog", (String)"id,number,name,parent,createtime", (QFilter[])qb.toArrays(), (String)"number");
        DynamicObjectCollection dataset = QueryServiceHelper.query((String)"epbs_basedataobject", (String)"id,number,name,catalog,type,modifytime as createtime", (QFilter[])strategyFilter.toArrays(), (String)"number");
        ArrayList treeList = Lists.newArrayListWithExpectedSize((int)16);
        if (catalogs.isEmpty()) {
            return;
        }
        for (DynamicObject data : catalogs) {
            memberMap = this.createMemberMap(data, "catalog");
            treeList.add(memberMap);
            if (data == null || !"0".equals(data.getString("parent"))) continue;
            rootId = data.getString("id");
        }
        if (!dataset.isEmpty()) {
            for (DynamicObject data : dataset) {
                memberMap = this.createMemberMap(data, "dataset");
                treeList.add(memberMap);
            }
        }
        treeList.sort(Comparator.comparing(t -> (String)t.get("name")));
        if (this.cache_treeList != null) {
            plugIn.getPageCache().put(this.cache_treeList, ObjectSerialUtil.toByteSerialized((Object)treeList));
        }
        root.setId(rootId);
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ManageTreeHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("type", "root");
        dataMap.put("dataset_number", "root");
        root.setData((Object)dataMap);
        this.setEntryNode(root, treeList, rootId);
        ManageTreeHelper.spreadAllNode(root);
        this.setTreeCache(root);
        plugIn.getPageCache().put(this.cache_headnodeid, rootId);
        TreeView tree = (TreeView)plugIn.getControl(this.treeViewctrlName);
        tree.deleteAllNodes();
        tree.addNode(root);
        if (newId != null) {
            TreeNode newNode = root.getTreeNode(newId, 20);
            if (newNode != null) {
                tree.focusNode(newNode);
                tree.treeNodeClick(newNode.getParentid(), newNode.getId());
            }
            plugIn.getPageCache().put(this.cache_focusnodeid, tree.getTreeState().getFocusNodeId());
        } else {
            tree.focusNode(root);
        }
        plugIn.getPageCache().put(this.cache_treeList + "1", SerializationUtils.toJsonString((Object)root));
        plugIn.getPageCache().put(this.cache_focusnodeid, tree.getTreeState().getFocusNodeId());
    }

    private void setTreeCache(TreeNode root) {
        this.plugIn.getPageCache().put("treelist", SerializationUtils.serializeToBase64((Object)root));
    }

    private Map<String, String> createMemberMap(DynamicObject dynamicObject, String type) {
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)6);
        if (dynamicObject != null) {
            String createtime;
            memberMap.put("id", dynamicObject.getString("id"));
            memberMap.put("number", dynamicObject.getString("number"));
            memberMap.put("name", dynamicObject.getString("name"));
            if (dynamicObject.containsProperty("type")) {
                memberMap.put("basicdatatype", dynamicObject.getString("type"));
            }
            if ((createtime = dynamicObject.getString("createtime")) == null) {
                createtime = TimeServiceHelper.now().toString();
            }
            memberMap.put("createtime", createtime);
            if ("catalog".equals(type)) {
                memberMap.put("parentid", dynamicObject.getString("parent"));
                memberMap.put("type", "catalog");
            } else {
                memberMap.put("parentid", dynamicObject.getString("catalog"));
                memberMap.put("type", "dataset");
            }
        }
        return memberMap;
    }

    private TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap nodeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            List nodeList = (List)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = Lists.newArrayListWithExpectedSize((int)16);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        return this.createNode(root, nodeMap, headId);
    }

    private TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            root.setIcon("kdfont kdfont-wenjianjia2 ");
            List children = root.getChildren();
            if (children == null) {
                children = Lists.newArrayListWithExpectedSize((int)16);
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                if ("catalog".equals(map.get("type"))) {
                    entry.setIcon("kdfont kdfont-wenjianjia2 ");
                } else if (map.containsKey("basicdatatype")) {
                    String baseDataType = map.get("basicdatatype");
                    HashMap<String, String> dic = new HashMap<String, String>();
                    dic.put("1", "kdfont kdfont-bianji8");
                    dic.put("4", "kdfont kdfont-zidingyi");
                    String others = "kdfont kdfont-cengji";
                    entry.setIcon(dic.getOrDefault(baseDataType, others));
                }
                entry.setText(map.get("name"));
                entry.setLongText(map.get("name"));
                dataMap.put("type", map.get("type"));
                dataMap.put("dataset_number", map.get("number"));
                dataMap.put("parentid", map.get("parentid"));
                dataMap.put("id", map.get("id"));
                dataMap.put("name", map.get("name"));
                entry.setData((Object)dataMap);
                String entryHeadId = map.get("id");
                this.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }

    public static void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                ManageTreeHelper.spreadAllNode(t);
            }
        }
    }

    public static DynamicObject addCatalogRoot() {
        QFilter nqFilter = new QFilter("number", "=", (Object)"root");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epbs_basedatacatalog", (String)"id,number,longname,name", (QFilter[])new QFilter[]{nqFilter});
        if (dynamicObject == null) {
            DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)"epbs_basedatacatalog");
            catalog.set("number", (Object)"root");
            catalog.set("longname", (Object)"root");
            catalog.set("name", (Object)ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ManageTreeHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            catalog.set("parent", (Object)0);
            SaveServiceHelper.save((IDataEntityType)catalog.getDynamicObjectType(), (Object[])new Object[]{catalog});
            return catalog;
        }
        return dynamicObject;
    }

    public static List<Long> getNodeAllChildId(String nodeId) {
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        ids.add(Long.parseLong(nodeId));
        QFBuilder qb = new QFBuilder("longname", "like", (Object)("%" + nodeId + "%"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ManageTreeHelper.class.getName(), (String)"epbs_basedatacatalog", (String)"id", (QFilter[])qb.toArrays(), null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong("id"));
        }
        dataSet.close();
        return ids;
    }

    public static TreeNode getCacheLefTreeRoot(AbstractFormPlugin plugIn) {
        String rootStr = plugIn.getPageCache().get("treelist");
        if (rootStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f13\u5b58\u7684\u5de6\u6811\u5931\u8d25\u3002", (String)"ManageTreeHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        TreeNode root = (TreeNode)SerializationUtils.deSerializeFromBase64((String)rootStr);
        return root;
    }

    public static TreeNode getSelectedNode(String nodeId, AbstractFormPlugin plugIn) {
        if (nodeId == null) {
            return null;
        }
        TreeNode root = ManageTreeHelper.getCacheLefTreeRoot(plugIn);
        return root.getTreeNode(nodeId);
    }
}

