/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.manage.task;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.bd.manage.BaseDataImportResultDivisionService;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataResult;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskResult;
import kd.epm.epbs.business.bd.manage.task.dto.TaskMessage;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import org.apache.poi.ss.usermodel.Workbook;

public class BaseDataImportResultDivisionTask
extends AbstractTask {
    private static final Double MaxProcessValue = 10000.0;
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance((boolean)true, BaseDataImportResultDivisionTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        String message = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"BaseDataImportResultDivisionTask_1", (String)"epm-epbs-business", (Object[])new Object[0]);
        this.feedbackProgress(0, message, null);
        DivisionBaseDataResult divisionBaseDataResult = null;
        DivisionBaseDataTaskInput taskInput = null;
        DivisionBaseDataTaskResult result = null;
        long startTime = System.currentTimeMillis();
        try {
            if (this.isStop()) {
                this.nowStop("");
                this.endTask(result, "");
                return;
            }
            if (params.get("input") == null || StringUtils.isEmpty((String)params.get("input").toString())) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BaseDataImportResultDivisionTask_2", (String)"epm-epbs-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(result, message);
                return;
            }
            result = (DivisionBaseDataTaskResult)JSON.parseObject((String)params.get("input").toString(), DivisionBaseDataTaskResult.class);
            taskInput = result.getInput();
            if (taskInput == null) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u5f02\u5e38\u3002", (String)"BaseDataImportResultDivisionTask_3", (String)"epm-epbs-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(result, message);
                return;
            }
            DivisionBaseDataInput divisionBaseDataInput = taskInput.getInput();
            if (divisionBaseDataInput == null) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u5f02\u5e38\u3002", (String)"BaseDataImportResultDivisionTask_3", (String)"epm-epbs-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(result, message);
                return;
            }
            AtomicInteger currrentProceess = new AtomicInteger(0);
            Consumer<TaskMessage> fillbackConsumer = r -> {
                if (this.isStop()) {
                    this.nowStop("");
                } else {
                    currrentProceess.addAndGet(r.getProcess().intValue());
                    this.feedbackProgress(currrentProceess.get() / 100, r.getMessage(), null);
                }
            };
            divisionBaseDataResult = BaseDataImportResultDivisionService.execute(result, fillbackConsumer, MaxProcessValue);
        }
        catch (KDBizException kdEx) {
            this.endTask(result, kdEx.getMessage());
            return;
        }
        catch (Exception e) {
            ErrorCode errorCode = ((KDException)e).getErrorCode();
            message = errorCode != null && "TASK_STOPED_BY_USER".equals(errorCode.getCode()) ? ResManager.loadKDString((String)"\u7ec8\u6b62\u4efb\u52a1\u6210\u529f\u3002", (String)"BaseDataDivisionTask_8", (String)"epm-epbs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u9519\u8bef\u6570\u636e\u5bfc\u51fa\u670d\u52a1\u5f02\u5e38\uff0c\u8be6\u60c5\u89c1\u65e5\u5fd7\u3002", (String)"BaseDataImportResultDivisionTask_4", (String)"epm-epbs-business", (Object[])new Object[0]);
            logger.error(message, (Throwable)e);
            this.endTask(result, message);
            return;
        }
        logger.info("epbs--------BaseDataImportResultDivisionTask:" + (System.currentTimeMillis() - startTime));
        DivisionBaseDataTaskResult taskResult = new DivisionBaseDataTaskResult();
        taskResult.setSuccess(true);
        taskResult.setResult(divisionBaseDataResult);
        taskResult.setInput(taskInput);
        taskResult.setMessage(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u9519\u8bef\u6570\u636e\u5bfc\u51fa\u670d\u52a1\u6267\u884c\u5b8c\u6bd5\u3002", (String)"BaseDataImportResultDivisionTask_5", (String)"epm-epbs-business", (Object[])new Object[0]));
        this.endTask(taskResult);
    }

    private void nowStop(String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            this.feedbackProgress(100, message, null);
        }
        this.stop();
    }

    private void endTask(DivisionBaseDataTaskResult result) {
        LinkedHashMap<String, String> customData = new LinkedHashMap<String, String>(10);
        customData.put("result", JSON.toJSONString((Object)result));
        this.feedbackCustomdata(customData);
    }

    private void endTask(DivisionBaseDataTaskResult result, String errorMsg) {
        DivisionBaseDataTaskResult taskResult = new DivisionBaseDataTaskResult();
        if (result != null) {
            DivisionBaseDataTaskInput input = result.getInput();
            taskResult.setInput(input);
            if (input != null) {
                Workbook workBook = input.getInput().getWorkBook();
                if (workBook != null) {
                    try {
                        workBook.close();
                    }
                    catch (IOException e) {
                        logger.error("workBook close  Interrupted", (Throwable)e);
                    }
                }
                input.getInput().setWorkBook(null);
            }
            taskResult.setResult(result.getResult());
        }
        taskResult.setSuccess(false);
        taskResult.setMessage(errorMsg);
        this.endTask(taskResult);
    }
}

