/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;

public class ModelF7ParamContext
implements Serializable {
    private static final long serialVersionUID = -6201633528243709267L;
    private String entityNumber;
    private String modelEntityNumber = "epbs_model";
    private int flag = 0;
    private List<AppTypeEnum> queryAppTypes;
    private AppTypeEnum srcAppType;

    public void setOnlyManager() {
        if ((this.flag & 1) == 0) {
            ++this.flag;
        }
    }

    public boolean isOnlyManager() {
        return (this.flag & 1) == 1;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public Collection<Long> getEffectiveModelIds() {
        Collection<Long> limitModelIds = this.getLimitedModelIds();
        if (this.isOnlyManager()) {
            return limitModelIds;
        }
        Collection<Long> perm = ModelPermHelper.getModelPermByUser(this.getSrcAppType(), this.entityNumber, "47150e89000000ac");
        HashSet<Long> modelPermIds = new HashSet<Long>(perm);
        modelPermIds.addAll(limitModelIds);
        return modelPermIds;
    }

    public QFilter genQFilter() {
        QFilter qf = new QFilter("id", "in", this.getEffectiveModelIds());
        if (this.getQueryAppTypes() != null) {
            QFilter qFilter = new QFilter("srcappnum", "=", (Object)this.getSrcAppType().getAppNum());
            if (AppTypeEnum.isEbApp((String)this.getSrcAppType().getAppNum())) {
                qFilter = new QFilter("srcappnum", "in", Arrays.asList(AppTypeEnum.EB.getAppNum(), AppTypeEnum.BGBD.getAppNum(), AppTypeEnum.BG.getAppNum()));
            }
            for (AppTypeEnum queryApp : this.getQueryAppTypes()) {
                if (qFilter == null) {
                    qFilter = new QFilter("appnums", "like", (Object)("%," + queryApp.getAppNum() + ",%"));
                    continue;
                }
                qFilter.or("appnums", "like", (Object)("%," + queryApp.getAppNum() + ",%"));
            }
            qf.and(qFilter);
        }
        return qf;
    }

    public Collection<Long> getLimitedModelIds() {
        return ModelPermHelper.getLimitedModelListByUser(this.getQueryAppTypes() != null ? this.getQueryAppTypes().toArray(new AppTypeEnum[0]) : null);
    }

    public List<AppTypeEnum> getQueryAppTypes() {
        return this.queryAppTypes;
    }

    public void setQueryAppTypes(List<AppTypeEnum> queryAppTypes) {
        this.queryAppTypes = queryAppTypes;
    }

    public AppTypeEnum getSrcAppType() {
        return this.srcAppType == null ? AppTypeEnum.EPBS : this.srcAppType;
    }

    public void setSrcAppNum(String appNum) {
        this.setSrcAppType(AppTypeEnum.getEnumByAppnum((String)appNum));
    }

    public void setSrcAppType(AppTypeEnum srcAppType) {
        this.srcAppType = srcAppType;
    }

    public String getModelEntityNumber() {
        return this.modelEntityNumber;
    }

    public void setModelEntityNumber(String modelEntityNumber) {
        this.modelEntityNumber = modelEntityNumber;
    }
}

