/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.model;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.bd.model.TempModelF7ParamContext;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.ModelUtil;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.QFBuilder;

public class ModelListHelper {
    private static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(ModelListHelper.class);
    public static final String MODEL_APP_INFO = "model_app_info";
    public static final String SRC_APPNUM = "srcappnum";
    public static final String F7PARAMS = "f7params";

    public static ModelF7ParamContext createModelF7Ctx(IFormView formView) {
        ModelF7ParamContext ctx = new ModelF7ParamContext();
        String entityId = formView.getEntityId();
        PermissionControlType permissionControlType = EntityMetadataCache.getPermissionControlType((String)entityId);
        if (permissionControlType.isControlFunction()) {
            if ("DIM_EPBS_MODEL".equals(permissionControlType.getDimension())) {
                ctx.setEntityNumber(entityId);
            } else {
                ctx.setOnlyManager();
            }
        }
        ctx.setSrcAppNum(formView.getFormShowParameter().getAppId());
        ctx.setQueryAppTypes(Stream.of(ModelListHelper.getModelEffectiveApps(ctx.getSrcAppType())).collect(Collectors.toList()));
        return ctx;
    }

    public static ModelF7ParamContext createTempModelF7Ctx(FormShowParameter showParameter) {
        List<Object> appTypes;
        AppTypeEnum appType = AppTypeEnum.getEnumByAppnum((String)showParameter.getAppId());
        TempModelF7ParamContext ctx = new TempModelF7ParamContext();
        switch (appType) {
            case EPBS: {
                appTypes = ModelUtil.getAppModelByEnum(null).stream().map(e -> e.getAppType()).collect(Collectors.toList());
                appTypes.remove(AppTypeEnum.RPT);
                break;
            }
            case BGBD: {
                appTypes = Lists.newArrayList((Object[])new AppTypeEnum[]{AppTypeEnum.BGMD, AppTypeEnum.EB, AppTypeEnum.BG});
                break;
            }
            default: {
                appTypes = Lists.newArrayList((Object[])new AppTypeEnum[]{appType});
            }
        }
        ctx.setQueryAppTypes((List<AppTypeEnum>)appTypes);
        ctx.setSrcAppType(appType);
        return ctx;
    }

    public static AppTypeEnum[] getModelEffectiveApps(AppTypeEnum appTypeEnum) {
        if (AppTypeEnum.EPBS == appTypeEnum) {
            return (AppTypeEnum[])AppTypeEnum.getApps((String)appTypeEnum.getAppNum()).stream().filter(e -> !AppTypeEnum.isEbApp((String)e.getAppNum()) && !AppTypeEnum.isCMApp((String)e.getAppNum()) && !AppTypeEnum.isFarApp((String)e.getAppNum())).toArray(AppTypeEnum[]::new);
        }
        if (AppTypeEnum.BGBD == appTypeEnum || AppTypeEnum.BGC == appTypeEnum) {
            return new AppTypeEnum[]{AppTypeEnum.BGMD, AppTypeEnum.EB, AppTypeEnum.BG};
        }
        if (AppTypeEnum.BGM == appTypeEnum) {
            return new AppTypeEnum[]{AppTypeEnum.BGMD};
        }
        if (AppTypeEnum.BGRP == appTypeEnum) {
            return new AppTypeEnum[]{AppTypeEnum.BGMD, AppTypeEnum.BG};
        }
        return new AppTypeEnum[]{appTypeEnum};
    }

    public static QFilter getModelEffectiveAppsQf(AppTypeEnum appTypeEnum) {
        QFBuilder qfBuilder = new QFBuilder();
        for (AppTypeEnum app : ModelListHelper.getModelEffectiveApps(appTypeEnum)) {
            qfBuilder.or("appnums", "like", (Object)("," + app.getAppNum() + ","));
        }
        return qfBuilder.toFilter();
    }

    public static void handleModelShowParam(ListShowParameter showParameter, ModelF7ParamContext _ctx) {
        showParameter.setBillFormId(_ctx.getModelEntityNumber());
        showParameter.setCustomParam(F7PARAMS, (Object)ObjectSerialUtil.toByteSerialized((Object)_ctx));
        showParameter.getListFilterParameter().setFilter(_ctx.genQFilter());
    }

    public static boolean check(Long modelId) {
        if (modelId == null || modelId < 1L) {
            return false;
        }
        ModelBean model = ModelCacheHelper.getModel((long)modelId);
        return model != null && model.getId() > 0L;
    }

    public static String getDelMessage() {
        return ResManager.loadKDString((String)"\u4f53\u7cfb\u6570\u636e\u4e0d\u5728\uff0c\u53ef\u80fd\u5df2\u5220\u9664\u3002", (String)"ModelListHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]);
    }
}

