/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.model;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.bd.model.ModelListHelper;
import kd.epm.epbs.business.bd.model.ModelSyncService;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppModelEnum;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.ModelUtil;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.common.util.ThrowableHelper;
import org.apache.commons.lang3.ArrayUtils;

public class ModelSyncBaseImpl
implements ModelSyncService {
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(ModelListHelper.class);
    protected static final String APPNUM = "appnums";
    protected static final String EpbsModelSaveFields = "id,number,name,shownumber,description,modifier,modifytime,creator,createtime,status,enable,datasource";

    public static ModelSyncService getInstance() {
        return new ModelSyncBaseImpl();
    }

    @Override
    public void saveEpbsModelByReportType(Long modelId, String reportType) {
        AppModelEnum appModelEnum = Arrays.stream(AppModelEnum.values()).filter(e -> StringUtils.isNotEmpty((String)e.getReportType()) && e.getReportType().equals(reportType)).findFirst().orElseGet(() -> null);
        if (null == appModelEnum) {
            return;
        }
        this.saveEpbsModel(modelId, appModelEnum.getAppType(), new AppTypeEnum[]{appModelEnum.getAppType()});
    }

    @Override
    public void saveEpbsModel(Long modelId, AppTypeEnum srcAppType, AppTypeEnum[] appTypes) {
        if (null == appTypes || appTypes.length == 0) {
            return;
        }
        try {
            DynamicObject modelByApp = ModelUtil.loadAppModel((Long)modelId, (String)srcAppType.getAppNum());
            if (null == modelByApp) {
                return;
            }
            this.saveEpbsModel(modelByApp, srcAppType, appTypes);
        }
        catch (Exception e) {
            logger.error(String.format("\u5e94\u7528\u4f53\u7cfb\u4fdd\u5b58\u5f02\u5e38:%s-%s-[%s]", modelId, srcAppType.getAppNum(), Arrays.stream(appTypes).map(AppTypeEnum::getAppNum).collect(Collectors.joining(","))));
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    @Override
    public void updateEpbsModel(Collection<Long> modelIds) {
        try {
            Object[] epbsModelDyns = BusinessDataServiceHelper.load((String)"epbs_model", (String)Joiner.on((String)",").join((Object)EpbsModelSaveFields, (Object)"srcappnum", new Object[]{APPNUM}), (QFilter[])new QFilter("id", "in", modelIds).toArray());
            if (ArrayUtils.isEmpty((Object[])epbsModelDyns)) {
                return;
            }
            Map<String, Map<Long, DynamicObject>> epbsModelMap = Arrays.stream(epbsModelDyns).collect(Collectors.groupingBy(k -> k.getString("srcappnum"), Collectors.toMap(e -> e.getLong("id"), e -> e)));
            Iterator<Map.Entry<String, Map<Long, DynamicObject>>> iterator = epbsModelMap.entrySet().iterator();
            iterator.forEachRemaining(entry -> {
                List appModelDyns = ModelUtil.loadAppModel(((Map)entry.getValue()).keySet(), (String)((String)entry.getKey()));
                for (DynamicObject appModel : appModelDyns) {
                    DynamicObject update = (DynamicObject)((Map)entry.getValue()).get(appModel.getLong("id"));
                    for (String fieldKey : EpbsModelSaveFields.split(",")) {
                        update.set(fieldKey, appModel.get(fieldKey));
                    }
                }
            });
            TXUtils.requiresNew(arg_0 -> ModelSyncBaseImpl.lambda$updateEpbsModel$6((DynamicObject[])epbsModelDyns, arg_0));
            ModelCacheHelper.invalidateModelKey((Collection)Arrays.stream(epbsModelDyns).collect(Collectors.toList()));
        }
        catch (Exception e2) {
            logger.error(String.format("\u5e94\u7528\u4f53\u7cfb\u6279\u91cf\u66f4\u65b0\u5f02\u5e38:%s", modelIds));
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e2, (int)30));
        }
    }

    @Override
    public void deleteEpbsModel(Collection<Long> modelIds) {
        try {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epbs_model", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", modelIds)});
            TXUtils.requiresNew((String)"epbs.deleteEpbsModel", tx -> {
                this.doDeleteEpbsModel(modelIds);
                ModelCacheHelper.invalidateModelKey((Collection)query);
            });
        }
        catch (Exception e) {
            logger.error(String.format("\u5e94\u7528\u4f53\u7cfb\u6279\u91cf\u5220\u9664\u5f02\u5e38:%s", modelIds));
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    @Override
    public void removeEpbsModel2Appnum(Map<Long, Collection<AppTypeEnum>> model2Appnums) {
        if (!model2Appnums.isEmpty()) {
            ArrayList<Long> delList = new ArrayList<Long>(10);
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"epbs_model", (String)"id,number,appnums", (QFilter[])new QFilter("id", "in", model2Appnums.keySet()).toArray());
            if (load != null && load.length > 0) {
                for (DynamicObject dy : load) {
                    String appnum = dy.getString(APPNUM);
                    Set collect = Arrays.stream(appnum.split(",")).filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toSet());
                    model2Appnums.get(dy.getLong("id")).forEach(e -> collect.remove(e.getAppNum()));
                    if (collect.isEmpty()) {
                        delList.add(dy.getLong("id"));
                        continue;
                    }
                    dy.set(APPNUM, (Object)collect.stream().collect(Collectors.joining(",", ",", ",")));
                    updateList.add(dy);
                }
                TXUtils.requiresNew((String)"epbs.modelupdateappnum", tx -> {
                    if (!delList.isEmpty()) {
                        DeleteServiceHelper.delete((String)"epbs_model", (QFilter[])new QFilter("id", "in", (Object)delList).toArray());
                        ModelPermHelper.delete(delList);
                    }
                    if (!updateList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                    }
                });
                ModelCacheHelper.invalidateModelKey((Collection)Arrays.stream(load).collect(Collectors.toList()));
            }
        }
    }

    protected void saveEpbsModel(DynamicObject modelByApp, AppTypeEnum srcAppType, AppTypeEnum[] appTypes) {
        DynamicObject epbsModel;
        boolean isSyncappNums;
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])new Object[]{modelByApp.getLong("id")}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epbs_model"));
        Set appnums = Arrays.stream(appTypes).map(e -> e.getAppNum()).collect(Collectors.toSet());
        appnums.add(srcAppType.getAppNum());
        if (load.length == 0) {
            isSyncappNums = false;
            epbsModel = ORM.create().newDynamicObject("epbs_model");
            epbsModel.set("srcappnum", (Object)srcAppType.getAppNum());
        } else {
            epbsModel = load[0];
            List collect = Arrays.stream(epbsModel.getString(APPNUM).split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            appnums.addAll(collect);
            isSyncappNums = collect.size() != appnums.size();
        }
        epbsModel.set(APPNUM, (Object)appnums.stream().collect(Collectors.joining(",", ",", ",")));
        String[] stringArray = EpbsModelSaveFields.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String fieldKey;
            Object value = modelByApp.get(fieldKey = stringArray[i]);
            epbsModel.set(fieldKey, value instanceof DynamicObject ? Long.valueOf(((DynamicObject)value).getLong("id")) : value);
        }
        if (load.length == 0) {
            TXUtils.requiresNew(tx -> SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{epbsModel}));
        } else {
            TXUtils.requiresNew(tx -> SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{epbsModel}));
        }
        ModelCacheHelper.invalidateModelKey(Collections.singleton(epbsModel));
    }

    protected void doDeleteEpbsModel(Collection<Long> modelIds) {
        DeleteServiceHelper.delete((String)"epbs_model", (QFilter[])new QFilter("id", "in", modelIds).toArray());
    }

    private static /* synthetic */ void lambda$updateEpbsModel$6(DynamicObject[] epbsModelDyns, TXHandle tx) {
        SaveServiceHelper.save((DynamicObject[])epbsModelDyns);
    }
}

